# Workers' Compensation Compliance Agent

AI agent skill for managing workers' compensation programs — classification codes, EMR optimization, premium audits, claims management, and 50-state compliance.

## What's Inside

- **NCCI class code reference** — Top 20 codes with rate ranges
- **EMR calculator framework** — Understand what drives your modifier and how to lower it
- **Premium audit checklist** — 10-point review to catch overcharges before your carrier does
- **State compliance matrix** — Monopolistic vs competitive states, coverage triggers, penalties
- **Return-to-work program** — Reduce claim costs by getting people back faster
- **Fraud detection** — Red flag indicators for questionable claims
- **Cost-per-injury tables** — Direct and indirect costs by injury type (OSHA/NSC data)

## Who This Is For

- Business owners managing workers' comp costs
- HR teams handling claims and compliance
- Safety managers building prevention programs
- Insurance brokers advising commercial clients
- Construction, manufacturing, and trades companies with high-risk classifications

## The Numbers

- Average US business pays $1.19 per $100 of payroll for workers' comp
- A single $10K claim can add $9K-$15K in extra premiums over 3 years
- Claims frequency penalizes your EMR more than severity
- 5 small claims cost more than 1 large claim of equal total value
- Proper classification alone can save 15-30% on premiums

## Quick Start

Install this skill in your AI agent and ask:
- "Audit my class codes for a construction company with 50 employees"
- "My EMR is 1.35 — what's driving it and how do I get it under 1.0?"
- "We're expanding to Ohio — what are the workers' comp requirements?"
- "Review our return-to-work program for gaps"

## More Business Operations Tools

Need AI agents for your entire back office? Check out the full collection:

🔗 [AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/) — Industry-specific AI agent configurations ($47/pack)

🔗 [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find out how much manual operations cost your business

🔗 [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Configure your AI agent stack in minutes

Built by [AfrexAI](https://github.com/afrexai-cto) — AI agents that run your business operations.
