# Web3 & Blockchain Engineering ⛓️

Complete methodology for evaluating, designing, building, securing, and operating blockchain-based systems. From "should I use blockchain?" to production DeFi protocols.

## Install

```bash
clawhub install afrexai-web3-engineering
```

## What's Inside

- **Database Test** — Decision framework: blockchain vs PostgreSQL
- **Platform Selection** — 10+ chains compared (Ethereum, Solana, Bitcoin, L2s)
- **Smart Contract Architecture** — Design patterns, upgrade strategies, Solidity standards
- **Token Economics** — Distribution, vesting, value accrual, red flag detection
- **DeFi Protocol Design** — AMMs, lending, security invariants
- **Security Auditing** — 100+ point checklist, vulnerability taxonomy, audit process
- **Testing Strategy** — Full pyramid (unit → fuzz → fork → formal verification)
- **Deployment & Ops** — Checklists, monitoring, incident response
- **Wallet Security** — Key hierarchy, multisig config, self-custody rules
- **L2 & Scaling** — Rollups, bridges, cross-chain security
- **Bitcoin & Lightning** — Integration patterns, self-custody, UTXO management
- **MEV Protection** — Sandwich attacks, front-running prevention
- **Account Abstraction** — ERC-4337, gasless UX, session keys
- **Regulatory Compliance** — US/EU/UK/Singapore frameworks, MiCA, Howey Test

Zero dependencies. Framework-agnostic. Works with any AI agent.

## Quick Start

```
> evaluate blockchain fit for our supply chain tracking
> design tokenomics for a governance token
> audit security on this Solidity contract
> plan deployment to Arbitrum
```

## ⚡ Level Up

This free skill gives you the engineering methodology. For complete industry-specific AI agent context packs with implementation playbooks:

**[AfrexAI Context Packs — $47 each](https://afrexai-cto.github.io/context-packs/)**

- 🏦 **Fintech Pack** — DeFi compliance, payment rails, regulatory frameworks
- 💻 **SaaS Pack** — Token-gated features, Web3 authentication, billing
- 🏗️ **Construction Pack** — Supply chain verification, payment automation

## 🔗 More Free Skills by AfrexAI

- [afrexai-agent-engineering](https://clawhub.com/skills/afrexai-agent-engineering) — Build production AI agent systems
- [afrexai-mcp-engineering](https://clawhub.com/skills/afrexai-mcp-engineering) — Model Context Protocol server development
- [afrexai-cybersecurity-engine](https://clawhub.com/skills/afrexai-cybersecurity-engine) — Complete security methodology
- [afrexai-system-architect](https://clawhub.com/skills/afrexai-system-architect) — System architecture design
- [afrexai-technical-seo](https://clawhub.com/skills/afrexai-technical-seo) — Technical SEO auditing

**Full catalog:** https://afrexai-cto.github.io/context-packs/
