# Web Performance Engine ⚡

Complete web performance optimization system for AI agents. Audit any website, diagnose bottlenecks, and fix them — with or without specialized tools.

## Install

```bash
clawhub install afrexai-web-performance-engine
```

## What It Does

- **Full Core Web Vitals audit** (LCP, FCP, TBT, CLS, INP, TTFB)
- **Bottleneck decision tree** — finds the root cause fast
- **10 fix playbooks** — server, render-blocking, images, JS, layout shifts, interactions
- **Resource loading strategy** — preload, prefetch, lazy loading done right
- **Third-party script audit** — with deferred loading patterns
- **Mobile-specific optimization** with targets and checklist
- **Performance budgets** with enforcement rules
- **100-point scoring rubric** across 8 dimensions
- **Framework-specific quick wins** (Next.js, WordPress, SPA, static)
- **Advanced techniques** — service workers, predictive prefetch, RUM monitoring

## Quick Start

```
"Audit https://example.com"
"What's slowing down my site?"
"Fix LCP on https://myapp.com"
"Set a performance budget for my project"
```

## Why This Over Other Performance Skills?

Other skills require Chrome DevTools MCP or external tools. This one works with **zero dependencies** — pure methodology. When tools are available, it uses them. When they're not, it guides you with web-based alternatives and manual checks.

19KB of actionable frameworks vs 7KB of tool-specific commands.

---

## ⚡ Level Up: AI Context Packs

Want to ship faster sites AND grow revenue? Our **SaaS Context Pack** ($47) includes complete technical + business playbooks for building high-performance SaaS products.

👉 [Browse all context packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-seo-content-engine](https://clawhub.com/skill/afrexai-seo-content-engine) — SEO-optimized content creation
- [afrexai-technical-docs](https://clawhub.com/skill/afrexai-technical-docs) — Documentation system
- [afrexai-code-reviewer](https://clawhub.com/skill/afrexai-code-reviewer) — Code review with SPEAR framework
- [afrexai-devops-engine](https://clawhub.com/skill/afrexai-devops-engine) — Complete DevOps & CI/CD
- [afrexai-api-architect](https://clawhub.com/skill/afrexai-api-architect) — API design & lifecycle

📦 [All AfrexAI skills on ClawHub](https://clawhub.com/?q=afrexai)
