# Warehouse Operations Optimizer

Turn your AI agent into a warehouse operations consultant. Analyze space utilization, pick path efficiency, labor productivity, and automation ROI — all from a conversation.

## What It Does

- **Space Utilization Audit** — Cubic utilization scoring, rack configuration, dead stock identification
- **Pick Path Optimization** — ABC slotting, travel time analysis, velocity-based recommendations
- **Labor Productivity Benchmarks** — Lines/hour, order accuracy, dock-to-stock metrics vs industry standards
- **Cost Per Order Breakdown** — Receiving, storage, pick & pack, shipping, returns
- **Automation ROI Calculator** — Conveyors, pick-to-light, AS/RS, AMRs, sortation with payback periods
- **Safety & Compliance** — OSHA checklist, DART rate benchmarking, ergonomic assessment

## Who It's For

Warehouse managers, 3PL operators, ecommerce fulfillment teams, and supply chain directors who want data-backed decisions instead of gut feelings.

## Quick Start

Install the skill, then tell your agent about your warehouse setup. It handles the rest.

## Example Prompts

- "Audit my 50,000 sq ft warehouse running 800 orders/day with 12 pickers"
- "Should I invest in pick-to-light or conveyor systems?"
- "My order accuracy is 98.7% — help me get to 99.5%+"
- "Calculate my cost per order and find where I'm bleeding money"

## Industry Benchmarks Included

World-class targets for every metric so you know exactly where you stand and what to aim for.

## Goes Well With

- [Manufacturing Context Pack](https://afrexai-cto.github.io/context-packs/) — Full production ops framework ($47)
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Quantify your operational waste
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Deploy your ops agent in minutes

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
