# 🎸 Vibe Coding Mastery

The complete operating system for building software with AI. Not tips — a full methodology.

## Install

```bash
clawhub install afrexai-vibe-coding
```

## What You Get

A 26KB comprehensive guide covering:

- **Decision Matrix** — When to vibe vs when to write code properly
- **Tool Selection** — Claude Code, Cursor, Windsurf, Copilot, Aider compared with multi-tool strategies
- **Rules File Templates** — Universal template + Cursor .mdc conditional rules + quality checklist
- **5-Level Prompt Hierarchy** — From "build me an app" (bad) to production-grade YAML contracts (great)
- **12 Proven Prompt Patterns** — Scaffolding, incremental, test-first, debug, review, migrate, and more
- **RPIV Workflow** — Research → Plan → Implement → Validate with checkpoint system
- **Vibe-Friendly Architecture** — Project structures, schema-first design, co-located tests
- **Testing Pyramid** — Test-first vibe pattern, what to test, when AI tests are wrong
- **Debugging Playbooks** — 3-strike rule, 4 recovery playbooks (spaghetti, recurring bugs, dep hell, context exhaustion)
- **Production Graduation Checklist** — P0 security through P3 quality (30+ items)
- **Advanced Patterns** — Parallel sessions, pair programming modes, context management, git workflow
- **15 Common Mistakes** — With consequences and specific prevention strategies
- **Weekly Effectiveness Tracker** — Score yourself, improve over time

## Quick Start

1. Install the skill
2. Read the Decision Matrix (Phase 1) — classify your project
3. Create your rules file (Phase 3) — use the universal template
4. Follow RPIV (Phase 5) — Research → Plan → Implement → Validate
5. Track weekly (Phase 12) — measure and improve

## Who This Is For

- Developers using AI coding tools daily
- Founders building MVPs with AI
- Teams establishing AI coding standards
- Anyone who wants to ship faster without shipping bugs

## ⚡ Level Up

This free skill covers the methodology. For industry-specific AI agent configurations:

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)** — Pre-built agent configurations for SaaS, Fintech, Healthcare, Legal, and 6 more verticals.

## 🔗 More Free Skills by AfrexAI

- `afrexai-prompt-engineering` — Master prompt design for any AI model
- `afrexai-agent-engineering` — Build production AI agent systems
- `afrexai-code-reviewer` — 60+ code review patterns across 5 languages
- `afrexai-api-architect` — Complete API lifecycle from design to monitoring
- `afrexai-devops-engine` — CI/CD, containers, observability, incident response

**[Browse all AfrexAI skills →](https://clawhub.com)**

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — we ship AI agents, not just AI prompts.*
