# Veterinary Practice Operations

Context pack for running a profitable, compliant veterinary practice. Covers service pricing benchmarks, DEA controlled substance compliance, OSHA safety programs, pharmacy/inventory management, staffing models, DVM compensation, and growth strategy from solo practice to multi-doctor hospital.

## When to Use
- Setting or reviewing veterinary service pricing
- DEA controlled substance compliance and biennial inventory
- OSHA veterinary workplace safety programs
- Pharmacy markup strategy and online pharmacy competition
- Staffing ratios, DVM compensation (ProSal, production, salary)
- Practice growth planning and acquisition economics
- KPI tracking and operational benchmarking

## Industry Context

**Market:** $35B+ US veterinary services | 33,000+ practices | 7-9% annual growth

### Service Pricing (2026)
| Service | Small Practice | Metro/Specialty |
|---------|---------------|-----------------|
| Wellness Exam | $55-75 | $75-120 |
| Spay (Dog, 40lb) | $250-400 | $400-600 |
| Dental Cleaning | $300-500 | $500-900 |
| Blood Panel (CBC+Chem) | $125-200 | $175-300 |
| ACL Surgery | $2,500-4,000 | $3,500-6,000 |
| Hospitalization/day | $200-400 | $400-800 |

Target: 25-35% net margin on services, 40-50% on retail/pharmacy.

### DEA Compliance
- Registration: DEA Form 224 ($888/3 years)
- Schedule II (fentanyl, injectable ketamine): double-locked safe, DEA 222 triplicate
- Schedule III-V: locked cabinet, biennial inventory
- Loss/theft: DEA Form 106 within 1 business day
- Penalties: up to $25,000/violation + license revocation

### OSHA Requirements
1. Hazard Communication (HazCom) — SDS sheets, labeled containers
2. Exposure Control Plan — bloodborne pathogens, sharps, zoonotic diseases
3. Radiation Safety — dosimetry badges, lead aprons, annual calibration
4. Anesthetic Gas Monitoring — WAM monitoring, scavenger systems
5. Formaldehyde Monitoring — if using formalin

### Staffing Per DVM
- Credentialed Vet Tech: 2-3 ($38K-55K)
- Vet Assistant: 1-2 ($28K-38K)
- Client Service Rep: 1 ($30K-42K)
- Practice Manager: 1 per 3-5 DVMs ($55K-85K)

### DVM Compensation
- ProSal: base + % of production over threshold (most common)
- Pure Production: 18-22% of personal production
- Salary: $110K-160K associate, $140K-200K+ experienced

### 10 KPIs
1. Revenue per DVM hour: $350-500+
2. Average Transaction Value: $200-350
3. New Client Growth: 15-25%/year
4. Client Retention: 80%+
5. No-Show Rate: <10%
6. Compliance Rate: 60-80%
7. AR >30 days: <5% of revenue
8. Staff Turnover: <20%/year
9. Inventory Turns: 8-12x/year
10. Net Profit Margin: 15-20%+

### Growth Stages
- Solo ($500K-$1M): 1 DVM, 15+ appts/day, wellness plans, Google reviews
- Multi-Doctor ($1M-$3M): 2-4 DVMs, dental suite, in-house lab, PIMS
- Hospital ($3M-$10M+): 5+ DVMs, specialists, urgent care, satellite locations

### Acquisition Valuations (2026)
- Solo: 4-6x EBITDA
- Multi-doctor: 5-8x EBITDA
- Corporate buyers (Mars/VCA, NVA): 8-12x for multi-doctor

## More from AfrexAI

- [Industry Context Packs ($47)](https://afrexai-cto.github.io/context-packs/)
- [AI Revenue Leak Calculator (Free)](https://afrexai-cto.github.io/ai-revenue-calculator/)
- [Agent Setup Wizard (Free)](https://afrexai-cto.github.io/agent-setup/)
