# Vendor Negotiation Playbook

Prepare for any vendor or supplier negotiation with a structured framework. This skill gives your AI agent the tools to research leverage, build counter-proposals, and close better deals on software, services, and materials contracts.

## What It Does

1. **Pre-negotiation research** — gather market rates, competitor pricing, and BATNA (best alternative) analysis
2. **Leverage assessment** — score your bargaining position across 8 dimensions
3. **Counter-proposal builder** — generate data-backed counter-offers with justification
4. **Concession strategy** — plan what to give and what to hold, in what order
5. **Contract term optimization** — flag unfavorable clauses and suggest alternatives
6. **Post-negotiation scorecard** — measure savings achieved vs. target

## Leverage Assessment (Score 1-5 Each)

| Factor | Score | Notes |
|--------|-------|-------|
| **Switching cost** | ___ | How painful is it to move to a competitor? |
| **Alternatives available** | ___ | How many viable alternatives exist? |
| **Volume leverage** | ___ | Are you a significant customer for them? |
| **Contract timing** | ___ | Is their quarter/year ending? Renewal coming? |
| **Market conditions** | ___ | Is their market competitive or consolidated? |
| **Relationship length** | ___ | Long-term customer = retention leverage |
| **Public pricing** | ___ | Can you cite published rates or benchmarks? |
| **Budget authority** | ___ | Can you credibly walk away? |

**Total: ___ / 40**
- 30-40: Strong position. Push for 15-30% reduction.
- 20-29: Moderate. Target 8-15% improvement.
- 10-19: Weak. Focus on terms, not price.
- Below 10: Consider bundling or multi-year for leverage.

## Negotiation Prep Template

```
=== VENDOR NEGOTIATION BRIEF ===

VENDOR: ___
CURRENT SPEND: $___/year
CONTRACT RENEWAL DATE: ___

WHAT WE'RE BUYING: ___
CURRENT PRICE: $___
TARGET PRICE: $___
BATNA (best alternative): ___
BATNA PRICE: $___

LEVERAGE SCORE: ___ / 40

TOP 3 NEGOTIATION POINTS:
1. ___
2. ___
3. ___

CONCESSIONS WE CAN OFFER:
- Multi-year commitment (2-3 years for ___% discount)
- Case study / reference (worth $___K in marketing to them)
- Expanded scope (add ___ users/seats for volume discount)
- Upfront payment (net-30 → prepay for ___% discount)

WALK-AWAY POINT: $___

RED LINES (non-negotiable):
- ___
- ___
```

## SaaS Negotiation Cheat Sheet

These tactics work on 80% of SaaS vendors:

**Timing plays:**
- Negotiate in their Q4 (Dec for calendar-year companies, Mar for fiscal-year)
- Wait until 2 weeks before auto-renewal — urgency shifts to them
- Start conversations in their slow season

**Price anchors:**
- "We've been quoted $X by [competitor]" — always have a real alternative
- "Our budget for this category is $X" — frame it as a constraint, not a request
- "At $X we'd sign a 2-year deal today" — give them certainty for discount

**Common SaaS discount ranges:**
| Tactic | Typical Discount |
|--------|-----------------|
| Annual prepay (vs monthly) | 15-20% |
| Multi-year (2yr) | 20-30% |
| Multi-year (3yr) | 25-40% |
| Volume tier jump | 10-25% |
| Case study / logo rights | 5-15% |
| Startup/SMB pricing | 20-50% |
| End-of-quarter deal | 10-30% |

**Terms to negotiate (not just price):**
- Payment terms: Net-60 or Net-90 instead of Net-30
- Auto-renewal: Require 60-day notice, not 30
- Price escalation cap: Max 5% annual increase
- Termination for convenience: 30-day out clause
- SLA credits: Real teeth — 10% credit per hour of downtime
- Data portability: Full export within 30 days of termination

## Services & Materials Negotiation

**For professional services:**
- Request blended rates instead of per-role pricing
- Cap T&M with a not-to-exceed amount
- Negotiate fixed-price for well-defined phases
- Include knowledge transfer deliverables
- Tie 15-20% of payment to deliverable acceptance

**For physical goods/materials:**
- Get 3 quotes minimum — always
- Negotiate FOB terms (who pays shipping)
- Request volume break schedule in writing
- Lock pricing for 6-12 months with escalation cap
- Payment: 50/40/10 (order/delivery/acceptance) not 100% upfront

## Post-Negotiation Scorecard

```
=== NEGOTIATION RESULTS ===

Original price: $___
Final price: $___
Savings: $___ (___%)

Target was: $___
Hit target: Yes / No / Exceeded

Key terms won:
- ___
- ___

Key concessions made:
- ___

Lessons for next time:
- ___
```

## Annual Vendor Review Calendar

| Month | Action |
|-------|--------|
| Jan | List all vendor contracts, renewal dates, annual spend |
| Feb-Mar | Identify top 10 vendors by spend — start research |
| Apr-May | Begin negotiations on upcoming renewals |
| Jun | Mid-year vendor consolidation review |
| Sep-Oct | Q4 negotiation window opens (best discounts) |
| Nov | Finalize multi-year deals before budget freeze |
| Dec | Audit: total savings achieved vs. target |

**Goal: 12-18% average reduction across vendor portfolio = found money.**

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI context packs that make business teams faster.
