# Vendor Evaluation & Due Diligence

Stop making $50K+ vendor decisions on gut feel and sales demos.

This skill gives your AI agent a structured 8-dimension framework to evaluate any software vendor, service provider, or technology partner — and produce a scored GO / CAUTION / NO-GO recommendation backed by real research.

## What It Covers

- **Financial Stability** — Is this vendor going to exist in 2 years?
- **Technical Fit** — Does it actually integrate with your stack?
- **Security & Compliance** — SOC2, ISO27001, GDPR readiness
- **Pricing Analysis** — Total cost of ownership, not just the sticker price
- **Reference Check** — What real customers say (not the case studies)
- **Support Quality** — SLAs that matter, not marketing promises
- **Vendor Lock-in Risk** — Can you leave without rebuilding everything?
- **Roadmap Alignment** — Are they building what you need next?

## Use Cases

- Evaluating SaaS tools before annual contracts
- Comparing 2-3 shortlisted vendors
- Due diligence before agency/contractor partnerships
- Technology stack decisions
- M&A technical assessment

## Example

> "Evaluate Salesforce vs HubSpot for a 40-person B2B SaaS company"

Your agent will research both, score them across all 8 dimensions, and give you a clear recommendation with negotiation leverage points.

## Who This Is For

Operations leaders, CTOs, procurement teams, and founders who want data-driven vendor decisions instead of whoever had the best sales pitch.

---

**Want more business decision frameworks?** Check out the full [AfrexAI Context Pack collection](https://afrexai-cto.github.io/context-packs/) — industry-specific AI agent configurations for SaaS, Legal, Healthcare, Fintech, and more. Starting at $47.

**Free tools:** [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) | [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)
