# Employee Training Program Builder

Build structured training programs for any role, department, or compliance requirement. Generates curricula, schedules, assessment criteria, and completion tracking.

## When to Use
- Onboarding new hires with role-specific training
- Rolling out compliance training (SOC 2, HIPAA, GDPR, OSHA)
- Upskilling teams on new tools or processes
- Building leadership development programs
- Creating certification prep paths

## Instructions

When asked to build a training program, gather:
1. **Role/audience** — Who's being trained?
2. **Objective** — What should they know/do after?
3. **Timeline** — How long is the program?
4. **Format** — Self-paced, instructor-led, blended?

Then generate:

### Program Structure
```
PROGRAM: [Name]
AUDIENCE: [Role/team]
DURATION: [X weeks]
FORMAT: [Self-paced / Instructor-led / Blended]

MODULE 1: [Topic]
- Learning objectives (3-5 measurable outcomes)
- Content outline (topics, subtopics)
- Activities (hands-on exercises, case studies)
- Assessment (quiz, practical demo, project)
- Time estimate: X hours
- Resources needed: [tools, access, materials]

MODULE 2: [Topic]
...
```

### Assessment Framework
For each module, define:
- **Knowledge check**: Quiz (70% pass rate minimum)
- **Practical assessment**: Demo or project deliverable
- **Competency rubric**: 1-5 scale per skill area

### Completion Tracking
```
| Employee | Module 1 | Module 2 | Module 3 | Overall | Status |
|----------|----------|----------|----------|---------|--------|
| Name     | ✅ 92%   | ✅ 88%   | 🔄 In Progress | 60% | On Track |
```

### Compliance Training Requirements
If compliance-related, include:
- Regulatory requirement citation
- Recertification frequency
- Documentation/record retention period
- Audit trail format

### ROI Metrics
Track training effectiveness:
- **Time to productivity**: Days from start to independent work
- **Error rate reduction**: Before/after training comparison
- **Retention impact**: 94% of employees stay longer at companies investing in training (LinkedIn 2024)
- **Cost per employee**: Program cost / participants

## Tips
- Break modules into 45-60 minute chunks (attention span sweet spot)
- Include at least one hands-on exercise per module
- Build in feedback loops — survey after each module
- Create "quick reference cards" for post-training support
- Schedule 30-day follow-up assessment to measure retention

## Resources
- Full context packs for 10 industries: https://afrexai-cto.github.io/context-packs/
- Calculate your AI automation ROI: https://afrexai-cto.github.io/ai-revenue-calculator/
- Agent setup wizard: https://afrexai-cto.github.io/agent-setup/
