# Token Economics Analyzer

Evaluate token and digital asset economics for business decisions. Covers utility tokens, governance tokens, loyalty points, tokenized assets, and vendor token lock-in risk.

## What It Does

- Scores tokenomics health across 5 dimensions (0-100)
- Classifies tokens into 5 business-relevant categories
- Provides accept/hold/launch/walk-away decision framework
- Assesses vendor token lock-in and price manipulation risk
- Maps token use cases across 10 industries with ROI estimates

## Use Cases

- Evaluating token-based vendor pricing
- Due diligence on token partnerships
- Designing tokenomics for product launches
- Treasury risk assessment for crypto holdings
- Regulatory posture evaluation

## Get Started

Install this skill in your OpenClaw agent, then ask it to evaluate any token or tokenomics model.

## More from AfrexAI

- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Free 2-minute assessment
- [Industry Context Packs ($47)](https://afrexai-cto.github.io/context-packs/) — Deep agent context for 10 verticals
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Build your stack in 5 minutes
