# Technical SEO Mastery 🔍

Complete technical SEO audit, fix, and monitoring system for AI agents. From crawlability to Core Web Vitals to international SEO.

## Install

```bash
clawhub install afrexai-technical-seo
```

## What It Does

- **Full technical audit** — crawlability, indexability, performance, mobile, security, schema
- **Core Web Vitals fix playbooks** — LCP, INP, CLS with prioritized actions
- **Schema markup templates** — JSON-LD for Organization, Article, Product, FAQ, and more
- **Site migration checklist** — pre/during/post migration with recovery timeline
- **0-100 scoring system** — weighted across 7 dimensions with priority fix matrix
- **Ongoing monitoring** — weekly + monthly checklists
- **Advanced** — JavaScript SEO, log file analysis, edge SEO, international/hreflang

## Quick Start

```
Run a technical SEO audit for https://example.com
```

```
Check Core Web Vitals and tell me what to fix first
```

```
Generate Product schema markup for my e-commerce pages
```

## What Makes This Different

Most SEO skills are either surface-level checklists or tool wrappers requiring API keys. This is a **complete methodology** — 14 phases covering every technical SEO dimension with YAML templates, fix playbooks, scoring rubrics, and priority matrices. Zero dependencies.

---

⚡ **Level up your AI agent's business intelligence:**

| Pack | Best For | Link |
|------|----------|------|
| SaaS Context Pack | SaaS technical + growth SEO | [Get it →](https://afrexai-cto.github.io/context-packs/) |
| Ecommerce Context Pack | Product page + category SEO | [Get it →](https://afrexai-cto.github.io/context-packs/) |
| Professional Services Pack | Service page + local SEO | [Get it →](https://afrexai-cto.github.io/context-packs/) |

🔗 **More free skills by AfrexAI:**
- `afrexai-seo-content-engine` — Content SEO & article optimization
- `afrexai-web-performance-engine` — Deep web performance optimization
- `afrexai-conversion-copywriter` — High-converting copy frameworks
- `afrexai-brand-strategy` — Brand identity & go-to-market
- `afrexai-growth-engine` — Full-stack growth system

Browse all: [AfrexAI on ClawHub](https://clawhub.com) | [Context Packs Store](https://afrexai-cto.github.io/context-packs/)
