# Technical Documentation Engine

Complete technical documentation system for AI agents — from audit through maintenance. Build docs that developers actually read.

## Install

```bash
clawhub install afrexai-technical-docs
```

## What It Does

- **Audit** existing docs with a structured scorecard (0-30 grading)
- **Generate** any doc type: READMEs, API refs, architecture docs, runbooks, ADRs, migration guides, error catalogs, changelogs, contributing guides
- **Score** documentation quality with a 100-point rubric across 8 dimensions
- **Maintain** docs with freshness tracking, debt management, and deprecation processes
- **Automate** with docs-as-code pipeline setup (lint, link check, coverage, preview)

## Quick Start

Tell your agent:

```
Audit the docs for my project
```

You'll get a scorecard showing gaps, a priority list, and effort estimates.

Then:

```
Write a README for [project]
Write a getting started guide for [feature]
Document this API endpoint: POST /users
Create a runbook for database failover
```

Every output follows battle-tested templates with examples and expected output.

## What's Inside

- 7 complete document templates (README, Getting Started, API Reference, Architecture, Runbook, Contributing, Changelog)
- 100-point quality scoring rubric
- Information architecture blueprint for developer portals
- Docs-as-code automation pipeline
- Migration guide and error catalog templates
- ADR (Architecture Decision Record) format
- Freshness tracking and documentation debt management
- Writing style guide with the 4C test

## ⚡ Level Up

Want industry-specific documentation frameworks? Our **Context Packs** ($47) include tailored documentation patterns for your vertical:

- **SaaS Pack** — API docs, SDK guides, developer portal architecture
- **Healthcare Pack** — HIPAA-compliant documentation, clinical workflow guides
- **Fintech Pack** — Regulatory documentation, audit trail templates
- **Manufacturing Pack** — SOP documentation, quality management systems

👉 [Browse all 10 vertical packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — SPEAR code review framework
- [afrexai-api-architect](https://clawhub.com/skills/afrexai-api-architect) — Complete API design lifecycle
- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — SEO content system
- [afrexai-project-manager](https://clawhub.com/skills/afrexai-project-manager) — Full PM delivery system
- [afrexai-prd-engine](https://clawhub.com/skills/afrexai-prd-engine) — PRD creation and management

🖤💛 Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/)
