# Technical Debt Audit

Systematic technical debt assessment for engineering teams. Discovers, scores, and prioritizes debt across your entire stack with dollar-cost estimates and a remediation roadmap.

Most engineering teams spend 23-42% of their time on tech debt but never measure it. This skill turns vague "we should refactor" conversations into a scored, prioritized action plan with real cost numbers.

## Features

- **6-category debt taxonomy** — architecture, code quality, dependencies, testing, infrastructure, documentation
- **Weighted priority scoring** — risk × 3, business impact × 2, inverse effort × 1
- **Carrying cost estimates** — dollars per month, velocity drag percentage
- **Remediation roadmap** — quick wins → scheduled work → strategic rewrites
- **Executive summary** — board-ready one-pager with debt-to-velocity ratio

## Who It's For

- Engineering managers tracking team velocity
- CTOs presenting debt reduction plans to the board  
- Tech leads prioritizing refactoring work
- Agencies auditing client codebases before taking over

## Quick Start

Install via ClawHub, then describe your system and known pain points. The agent handles the rest.

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) | [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) | [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)
