# Tax Planning & Strategy

AI agent skill for business tax optimization. Covers entity structure analysis, deduction maximization, quarterly calendars, compensation strategy, and year-end moves.

## What It Does
- Analyzes entity structure (LLC vs S-Corp vs C-Corp vs Ltd) with break-even math
- Runs through 10-category deduction checklist with dollar estimates
- Generates quarterly tax calendar (US IRS + UK HMRC)
- Models tax-efficient owner compensation splits
- Year-end tax move checklist
- International tax considerations (treaties, VAT, PE rules)
- Flags 7 most common costly mistakes

## Who It's For
- Small business owners and founders
- Freelancers and contractors earning $80K+
- Finance teams at SMBs without dedicated tax staff
- Accountants looking for AI-assisted client advisory

## Usage
Tell your AI agent: "Help me with tax planning" or "Optimize my business taxes"

## Links
- [AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/) — Industry-specific AI agent configurations ($47/pack)
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — See what AI automation saves your business
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Get your AI agent running in minutes
