# SWOT Analyzer 🖤💛

Structured SWOT analysis for your AI agent. Drop it in and get prioritized strategic assessments with scored impact matrices and actionable recommendations.

## What it does

- Runs a full Strengths / Weaknesses / Opportunities / Threats analysis
- Scores each factor by impact × likelihood for real prioritization
- Generates SO/WO/ST/WT cross-strategies (not just a list — actual moves)
- Uses web search to pull in current market data when available
- Challenges weak inputs — no "everything is fine" analyses

## Install

```bash
clawhub install afrexai-swot-analyzer
```

## Usage

Just ask your agent to run a SWOT analysis on anything:

- "Run a SWOT on our Q2 product launch"
- "SWOT analysis for entering the healthcare vertical"
- "Analyze our competitive position vs [competitor]"

The skill handles the rest — gathering context, researching, scoring, and recommending.

## Output

You get a scored matrix with prioritized strategic moves, not just four bullet-point lists. Each item is rated impact × likelihood so you know what to act on first.

## Part of the AfrexAI toolkit

Built by the team behind [AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/) — drop-in knowledge bundles that make AI agents actually useful from day one. Industry-specific packs available for fintech, healthcare, legal, construction, and more.

Free tools:
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — see if AI agents make financial sense for your team
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — get configured in 5 minutes
