# Supply Chain Risk Monitor

Map supplier dependencies, score vulnerabilities, and generate disruption mitigation plans — all from your AI agent.

## Why This Exists

Supply chain disruptions cost Fortune 500s $184M per event. Most companies don't know their Tier 2+ exposure until something breaks. This skill gives your agent a structured framework to assess, score, and mitigate supply chain risk before it hits your P&L.

## Features

- **Dependency mapping** — Tier 1/2/3 supplier concentration analysis
- **7-factor risk scoring** — Geographic, single-source, lead time, financial health, compliance, substitutability, inventory
- **Disruption modeling** — Revenue-at-risk calculations with recovery timelines
- **Mitigation roadmaps** — 30/60/90 day action plans with budget estimates

## Quick Start

Install via ClawHub, then ask your agent:

```
"Assess our supply chain risk"
"Model a 30-day China disruption"
"Create a supplier diversification plan"
```

## Who It's For

- Operations leaders managing 10+ suppliers
- Procurement teams building resilience programs
- CFOs quantifying supply chain exposure
- Anyone preparing for SOC 2 / ISO 27001 vendor risk requirements

## Goes Well With

- [AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/) — Industry-specific AI agent configs ($47/pack)
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money to manual processes
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Get your AI agent configured in minutes

---

🖤💛 Built by AfrexAI
