# Stripe Production Engineering

Complete methodology for building, scaling, and operating production Stripe payment systems. From first checkout to enterprise billing at scale.

## What This Skill Does

Gives your AI agent deep knowledge of Stripe production engineering:

- **Architecture patterns** — Checkout vs Payment Element vs Direct API decision framework
- **Subscription lifecycle** — Create, upgrade, downgrade, cancel, pause, dunning
- **Webhook mastery** — Signature verification, idempotency, event routing, error handling
- **Stripe Connect** — Marketplace payment flows (Standard/Express/Custom)
- **Security & PCI** — SAQ-A compliance, key management, fraud prevention
- **Usage-based billing** — Metered subscriptions with aggregated usage reporting
- **Tax collection** — Stripe Tax setup, EU VAT, US sales tax nexus
- **Testing strategy** — Test cards, CLI setup, edge case coverage
- **Go-live checklist** — Pre-production verification (P0/P1/P2)
- **Operations** — Revenue metrics, dispute handling, dunning optimization

## Install

```bash
clawhub install afrexai-stripe-production
```

## Quick Start

Ask your agent:
- "Set up Stripe checkout for my SaaS"
- "Add subscription billing with plan changes"
- "Configure webhook handler with idempotency"
- "Run the go-live checklist"
- "Stripe security audit"

## Who This Is For

- **SaaS founders** building subscription billing
- **Developers** integrating Stripe for the first time
- **Teams** migrating from basic Checkout to production-grade billing
- **Marketplaces** implementing Stripe Connect

## ⚡ Level Up

This free skill covers Stripe engineering methodology. For complete business automation context packs ($47):

- **[SaaS Context Pack](https://afrexai-cto.github.io/context-packs/)** — Full SaaS ops: billing + onboarding + support + growth
- **[Fintech Context Pack](https://afrexai-cto.github.io/context-packs/)** — Payments, compliance, risk management
- **[Ecommerce Context Pack](https://afrexai-cto.github.io/context-packs/)** — Store ops, inventory, multi-channel payments

## 🔗 More Free Skills by AfrexAI

- `afrexai-api-architect` — API design, security, versioning
- `afrexai-nextjs-production` — Next.js production engineering
- `afrexai-supabase-production` — Supabase production patterns
- `afrexai-database-engineer` — Schema design, query optimization
- `afrexai-compliance-engine` — SOC 2, GDPR, PCI DSS

Browse all: [AfrexAI on ClawHub](https://clawhub.com/afrexai-cto) | [Context Pack Store](https://afrexai-cto.github.io/context-packs/)
