# Strategic Thinking & Mental Models Engine

**By AfrexAI** 🖤💛

The most comprehensive decision-making skill on ClawHub. 50+ mental models organized by situation — business strategy, investing, hiring, risk, product, negotiations, and personal decisions. Includes scoring rubrics, YAML templates, bias defenses, and a decision record system.

## Install

```bash
clawhub install afrexai-strategic-thinking
```

## What's Inside

- **/8 Quick Health Check** — Score any decision process in 60 seconds
- **Type 1/Type 2 Classification** — Match your process to the stakes
- **50+ Mental Models** organized by category:
  - Strategy: Porter's Five Forces, Moat Assessment, OODA Loop, Wardley Mapping
  - Investment: Expected Value, Kelly Criterion, Margin of Safety, Asymmetric Bets
  - Product: ICE Scoring, Jobs To Be Done, Eisenhower Matrix
  - Risk: Pre-Mortem, Scenario Planning, Antifragility Assessment
  - People: Circle of Competence, Steel Man, Second-Order Thinking
  - Negotiation: BATNA Analysis, Cialdini's 6 Principles
  - Technical: Build vs Buy, Reversibility-First Architecture
- **12 Cognitive Bias Defenses** with daily checklist
- **Confidence Calibration** — Stop being overconfident
- **Group Decision Protocol** — Structured disagreement that works
- **100-Point Decision Quality Rubric**
- **Decision Record Template** (YAML) for tracking and reviewing
- **Situation → Framework Quick Reference** — know which model to use when

## Quick Start

Just say: **"Help me decide [your decision]"**

The skill walks you through classification, framework selection, analysis, scoring, and documentation.

## ⚡ Level Up

Want comprehensive frameworks for your specific industry? Check out our **AI Agent Context Packs** ($47 each) — deep operational knowledge for Fintech, Healthcare, Legal, SaaS, and 6 more verticals.

👉 [Browse Context Packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- `afrexai-negotiation-mastery` — Complete negotiation system with scripts
- `afrexai-competitive-intel` — 7-phase competitive intelligence methodology
- `afrexai-founder-os` — Startup operating system (0 → PMF → scale)
- `afrexai-sales-playbook` — Full B2B sales methodology (MEDDPICC + scripts)
- `afrexai-pricing-strategy` — Data-driven pricing frameworks

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI agents that compound.*
