# Startup Metrics Command Center

The most comprehensive startup metrics skill for AI agents. Not just formulas — complete diagnostic frameworks, cohort analysis methodology, board-ready reporting templates, and action playbooks for when numbers go wrong.

## Install

```bash
clawhub install afrexai-startup-metrics-engine
```

## What's Inside

- **Complete formula reference** — Revenue, unit economics, retention, growth efficiency, cash, sales metrics with benchmarks at every stage
- **PULSE diagnostic framework** — Pattern → Upstream → Leverage → So-What → Experiment methodology for investigating metric problems
- **Cohort analysis system** — Revenue and engagement cohort tables with red flag detection
- **Investor reporting templates** — Monthly update template, board deck metric slides, fundraising-stage checklists
- **Model-specific metrics** — SaaS, marketplace, consumer/PLG, hardware+software
- **Action playbooks** — Step-by-step fixes for high CAC, high churn, stalled growth
- **Vanity metric detector** — Identify and replace misleading metrics with real ones

## Quick Start

Ask your agent:
- "Set up metrics for seed-stage SaaS startup"
- "Diagnose why our churn increased"
- "Build investor update for January"
- "What metrics do I need for Series A?"

## Who This Is For

Founders, operators, and finance teams tracking startup health from pre-seed through growth stage. Works with any AI agent (OpenClaw, Claude, GPT).

---

⚡ **Level Up Your Agent**

Get the complete **SaaS Context Pack** ($47) — industry-specific frameworks, competitive intelligence, pricing strategy, and growth playbooks for SaaS companies:

👉 [Browse Context Packs](https://afrexai-cto.github.io/context-packs/)

🔗 **More free skills by AfrexAI:**
- [afrexai-pricing-strategy](https://clawhub.com/skills/afrexai-pricing-strategy) — Complete pricing system
- [afrexai-data-analyst](https://clawhub.com/skills/afrexai-data-analyst) — DICE analysis framework
- [afrexai-competitive-intel](https://clawhub.com/skills/afrexai-competitive-intel) — 7-phase competitive intelligence
- [afrexai-prd-engine](https://clawhub.com/skills/afrexai-prd-engine) — Product requirements system
- [afrexai-business-automation](https://clawhub.com/skills/afrexai-business-automation) — 5-phase automation lifecycle

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛*
