# Startup Fundraising Engine ⚡

Complete fundraising operating system for founders raising pre-seed through Series B.

## What This Does

Turns your AI agent into a fundraising advisor that covers:
- **Readiness Assessment** — 8-signal scoring to know if you're ready
- **Investor Targeting** — Pipeline building with tiered strategy
- **Pitch Deck Construction** — 12-slide framework with quality checklist
- **Financial Modeling** — Unit economics, projections, revenue benchmarks
- **Term Sheet Negotiation** — Red flag detection + word-for-word scripts
- **Due Diligence Prep** — Complete data room checklist
- **Cap Table Management** — Dilution math every founder must know
- **Process Management** — 8-12 week sprint framework

## Install

```bash
clawhub install afrexai-startup-fundraising
```

## Quick Start

Ask your agent:
- "Assess my fundraising readiness"
- "Review my pitch deck"
- "Analyze this term sheet"
- "Calculate dilution for $5M at $20M pre-money"

## Why This Over Other Skills?

Existing fundraising skills on ClawHub are either generic bullet points or narrow tools. This is a **complete operating system** — 34KB of methodology with YAML templates, scoring rubrics, negotiation scripts, and stage-specific guidance from pre-seed to Series B.

## ⚡ Level Up

Get industry-specific context for your fundraising:
**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)**
SaaS, Fintech, Healthcare, Legal, Construction, Ecommerce, Real Estate, Recruitment, Manufacturing, Professional Services.

## 🔗 More Free Skills by AfrexAI

- `afrexai-founder-os` — Complete founder operating system
- `afrexai-investor-engine` — Investment analysis (investor side)
- `afrexai-business-model-engine` — Business model design
- `afrexai-pricing-strategy` — Pricing optimization
- `afrexai-indie-hacker-engine` — Solo founder operating system

[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)
