# Stakeholder Report Generator

Turn messy project notes into executive-ready stakeholder reports in seconds.

Covers: executive summary, milestone tracking, budget variance, risk register, decision log, and next-period outlook. Adapts tone for board, investors, clients, or internal leadership.

## Why This Exists

Writing stakeholder reports eats 2-4 hours per week for most project leads. This skill turns raw bullet points into a structured report your CFO would approve.

## What You Get

- **Executive Summary** with health indicator (🟢🟡🔴)
- **Milestone Tracker** with status and dates
- **Budget Snapshot** with variance and burn rate
- **Risk Register** with likelihood, impact, and mitigations
- **Decision Log** for items needing stakeholder input
- **Next Period Outlook** with planned deliverables

## Quick Start

Install in OpenClaw:
```
clawhub install afrexai-stakeholder-report
```

Then tell your agent:
```
Generate a stakeholder report for Project Atlas.
Period: Feb 3-14, 2026
Updates: Shipped auth module, 2 days behind on API integration,
budget at 78% with 60% of scope complete, need decision on
vendor switch by Feb 20.
Audience: board
```

## Need More?

This skill handles the reporting layer. For the full operational toolkit — financial modeling, compliance frameworks, capacity planning, and 10 industry-specific context packs:

**[Browse AfrexAI Context Packs →](https://afrexai-cto.github.io/context-packs/)**

- 10 Industry Packs — $47 each
- Pick 3 Bundle — $97
- All 10 — $197
- Everything Bundle — $247

**[Free AI Revenue Calculator →](https://afrexai-cto.github.io/ai-revenue-calculator/)** — Find where your business is leaking money to manual processes.

**[Agent Setup Wizard →](https://afrexai-cto.github.io/agent-setup/)** — Configure your AI agent stack in 5 minutes.

---

Built by AfrexAI 🖤💛
