# Stakeholder Management Mastery

**The complete stakeholder identification, analysis, and engagement system for AI agents.**

Stop losing projects to politics. This skill turns your AI agent into a stakeholder strategist — mapping power dynamics, designing engagement plans, and navigating difficult personalities across any initiative.

## Install

```bash
clawhub install afrexai-stakeholder-management
```

## What It Does

- **Stakeholder Register** — Structured YAML profiles with attitude, influence, motivators, and history
- **Power/Interest Analysis** — Mendelow's Matrix with engagement strategies per quadrant
- **SCARF Threat Analysis** — Diagnose WHY stakeholders resist (Status, Certainty, Autonomy, Relatedness, Fairness)
- **Engagement Playbooks** — Step-by-step strategies for converting opponents, maintaining champions, managing blockers
- **Difficult Stakeholder Scenarios** — HiPPO, Ghost, Scope Creeper, Passive-Aggressive, Coalition Blocker
- **Political Mapping** — Informal power structures, alliances, tensions, influence networks
- **Health Dashboard** — RAG-scored stakeholder health with engagement metrics
- **Steering Committee Templates** — Agenda, governance, escalation framework
- **Change Curve Management** — Kübler-Ross stage mapping with targeted responses
- **100-Point Scoring System** — 6-dimension monthly stakeholder engagement score

## Quick Start

Tell your agent:
- *"Map stakeholders for the platform migration project"*
- *"How do I handle a VP who agrees in meetings but undermines in hallways?"*
- *"Create an engagement plan for the CFO"*
- *"Stakeholder health check"*

## Why This Exists

Most stakeholder management advice is a 2x2 matrix and "communicate regularly." That's not enough when you're navigating a VP who ghosts you, a team that's passively resisting, or a steering committee that can't make decisions.

This skill gives you the complete toolkit — from initial mapping through political navigation to monthly governance.

## ⚡ Level Up

Need stakeholder management tailored to your industry? Our context packs include industry-specific stakeholder maps, common personas, and engagement templates:

- **[SaaS Context Pack](https://afrexai-cto.github.io/context-packs/)** — Product, engineering, and customer stakeholder dynamics
- **[Professional Services Pack](https://afrexai-cto.github.io/context-packs/)** — Client relationship management and partner engagement
- **[Construction Pack](https://afrexai-cto.github.io/context-packs/)** — Contractor, regulatory, and community stakeholder management

## 🔗 More Free Skills by AfrexAI

- [afrexai-negotiation-mastery](https://clawhub.com/skill/afrexai-negotiation-mastery) — 7-phase negotiation system with scripts
- [afrexai-project-manager](https://clawhub.com/skill/afrexai-project-manager) — Complete PM delivery system
- [afrexai-meeting-mastery](https://clawhub.com/skill/afrexai-meeting-mastery) — Meeting prep, agendas, and follow-up
- [afrexai-proposal-engine](https://clawhub.com/skill/afrexai-proposal-engine) — Deal-winning proposal methodology
- [afrexai-competitive-intel](https://clawhub.com/skill/afrexai-competitive-intel) — 7-phase competitive intelligence

**Browse all AfrexAI skills →** [clawhub.com](https://clawhub.com)

**Full product catalog →** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
