# Staffing Agency Operations

Run a staffing agency with hard numbers. Covers temp, temp-to-hire, and direct placement across light industrial, clerical, healthcare, and IT verticals.

## Billing & Markup Rates

| Vertical | Bill Rate Range | Typical Markup | Temp-to-Hire Fee |
|---|---|---|---|
| Light Industrial | $15-22/hr | 35-55% | 15-25% annual salary |
| Clerical/Admin | $18-30/hr | 40-60% | 20-30% annual salary |
| Healthcare (CNA/LPN) | $22-45/hr | 35-50% | $3,000-8,000 flat |
| IT/Technical | $45-150/hr | 30-45% | 20-25% annual salary |
| Accounting/Finance | $25-65/hr | 40-55% | 20-30% annual salary |
| Executive Search | N/A | N/A | 25-33% annual salary (retained) |

## Gross Margin Targets

- Temp staffing: 22-28% gross margin (after payroll burden)
- Temp-to-hire: 25-35% blended
- Direct placement: 80-90% (fee minus recruiter cost)
- Blended agency target: 28-32% gross margin

## Payroll Burden (on top of pay rate)

| Component | Rate |
|---|---|
| FICA (employer share) | 7.65% |
| FUTA | 0.6% (first $7K) |
| SUTA | 1.5-5.4% (state-dependent) |
| Workers' Comp | 1-15% (industry-dependent) |
| ACA compliance (30+ hrs) | $350-550/mo per employee |
| General liability | 0.5-1.5% of payroll |
| **Total burden** | **12-30% of pay rate** |

## Key Metrics (Weekly Dashboard)

| Metric | Target | Red Flag |
|---|---|---|
| Fill rate | >85% | <70% |
| Time-to-fill | <3 days (light industrial), <10 days (professional) | >7 / >21 |
| Gross margin % | >25% | <20% |
| Temp turnover (weekly) | <8% | >15% |
| Recruiter productivity | 8-12 placements/week (temp), 2-4/month (perm) | <5 / <1 |
| Days sales outstanding (DSO) | <35 days | >50 days |
| Client retention (annual) | >80% | <65% |
| Workers' comp mod rate | <1.0 | >1.2 |

## Compliance Requirements

### Federal
- **I-9 verification** — within 3 business days of start. E-Verify if government contracts. Fines: $252-$2,507 per form (first offense), $2,507+ repeat.
- **ACA employer mandate** — if 50+ FTE, offer coverage to anyone averaging 30+ hrs/week. Penalty: $2,970/employee (2026).
- **FLSA** — joint employer liability. You AND the client can be liable for wage violations.
- **OSHA** — staffing agency shares responsibility for worksite safety. Must conduct site assessments.

### State-Specific
- **Licensing** — required in: CA, FL, IL, MA, NJ, NY, TX, and others. Fees: $100-$5,000. Some require surety bonds ($10K-$100K).
- **Pay transparency** — CA, CO, NY, WA require pay ranges in job postings.
- **Ban-the-box** — 37 states restrict criminal history questions on applications.
- **Temp worker bills of rights** — IL (2024), NJ (2023) require equal pay/benefits parity. More states following.

## Technology Stack Costs

| System | Monthly Cost | Purpose |
|---|---|---|
| ATS (Bullhorn/JobDiva) | $100-200/user | Applicant tracking, client management |
| VMS integration | $500-2,000 | Vendor management system connectivity |
| Payroll/billing (TempWorks/Avionte) | $5-15/employee/month | Payroll processing, invoicing |
| Background checks | $25-75/check | Pre-employment screening |
| Drug testing | $30-60/test | DOT and client requirements |
| Job board posting | $300-1,200/month | Indeed, LinkedIn, ZipRecruiter |
| Workers' comp (PEO vs direct) | 3-12% of payroll | Coverage and claims management |

## Growth Playbook

### Stage 1: $0-$500K revenue
- Solo owner-operator + 1 recruiter
- Single vertical focus (pick one: light industrial OR clerical)
- 15-30 temps on assignment at any time
- Startup costs: $20K-$75K (licensing, insurance, payroll funding)
- **Critical**: secure payroll funding line — you pay temps weekly, clients pay net-30

### Stage 2: $500K-$2M revenue
- 3-5 internal staff (recruiters + account manager)
- Add second vertical
- 50-100 temps on assignment
- Invest in ATS, systematize onboarding
- Workers' comp mod rate becomes make-or-break

### Stage 3: $2M-$10M revenue
- Branch office or second market
- Dedicated sales team vs recruiting team
- 150-500+ temps on assignment
- VMS/MSP program participation
- Consider direct placement division (higher margins)

### Stage 4: $10M+ revenue
- Multi-market, multi-vertical
- M&A for geographic expansion
- Technology platform investment
- Enterprise MSP contracts
- Exit multiples: 0.5-1.5x revenue, 4-8x EBITDA

## Cash Flow Warning

Staffing is a **cash-intensive** business. You fund payroll before collecting from clients.

| Revenue Level | Working Capital Needed |
|---|---|
| $500K/yr | $40-80K credit line |
| $2M/yr | $150-300K credit line |
| $10M/yr | $750K-$1.5M credit line |

Factoring (selling invoices at 2-5% discount) is common for agencies under $5M. Transition to traditional LOC as you scale.

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI agents that actually know your industry. Get the full [Recruitment Context Pack ($47)](https://afrexai-cto.github.io/context-packs/) or try the free [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/).*
