# AfrexAI SRE & Incident Management Platform ⚡

The most comprehensive SRE skill on ClawHub. Complete system from SLO definition through incident response, chaos engineering, toil management, and operational excellence.

## Install

```bash
clawhub install afrexai-sre-platform
```

## What's Inside

- **Reliability Assessment** — 8-dimension maturity model with scoring
- **SLI/SLO Framework** — Selection guides, burn rate alerts, 28-day rolling windows
- **Error Budget Management** — 4-state policy with automated escalation rules
- **Monitoring Architecture** — Golden Signals + USE + RED methods, alert design rules
- **Incident Response** — Full ICS framework, severity matrix, communication templates
- **Postmortem Framework** — Blameless template, Five Whys, Fishbone analysis, action tracking
- **Chaos Engineering** — 12 experiment templates, Game Day runbook, maturity model
- **Toil Management** — Inventory, priority matrix, automation targets
- **Capacity Planning** — Growth modeling, load testing benchmarks, scaling strategies
- **On-Call Excellence** — Health metrics, rotation practices, handoff templates, runbook template
- **Production Readiness Review** — 28-point checklist before any service goes live
- **Self-Healing Patterns** — Auto-remediation templates, multi-region strategies

## Quick Start

```
"Assess reliability for payment-service"
"Define SLOs for our API gateway"
"Start incident for elevated 5xx errors on checkout"
"Plan chaos experiment for database failover"
```

## ⚡ Level Up

This free skill gives you the methodology. For industry-specific reliability patterns:

- **[SaaS Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — SaaS-specific SLOs, multi-tenant reliability, PLG scaling
- **[Fintech Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — Financial system SLOs, compliance monitoring, payment reliability
- **[Healthcare Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — HIPAA-aware incident response, clinical system reliability

## 🔗 More Free Skills by AfrexAI

- [afrexai-devops-engine](https://clawhub.com/skills/afrexai-devops-engine) — CI/CD, Kubernetes, observability
- [afrexai-cybersecurity-engine](https://clawhub.com/skills/afrexai-cybersecurity-engine) — OWASP, pen testing, security program
- [afrexai-system-architect](https://clawhub.com/skills/afrexai-system-architect) — Architecture patterns, C4 models, scaling
- [afrexai-database-engineer](https://clawhub.com/skills/afrexai-database-engineer) — Schema design, query optimization, migrations
- [afrexai-compliance-engine](https://clawhub.com/skills/afrexai-compliance-engine) — SOC 2, ISO 27001, GDPR, HIPAA

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
