# Sprint Retrospective Facilitator

Run structured sprint retrospectives that produce real action items — not vague "we should communicate better" fluff.

## What It Does

1. **Collects input** from the team across 4 categories: What went well, What didn't, What confused us, What should we try next
2. **Groups and prioritizes** themes by frequency and impact
3. **Generates action items** with owners, deadlines, and success criteria
4. **Produces a retro report** ready to share with stakeholders
5. **Tracks patterns** across sprints to surface recurring issues

## How to Use

Tell the agent:
- `Run a retrospective for Sprint 24` — starts the full facilitation flow
- `Quick retro: [paste team feedback]` — processes raw feedback into structured output
- `Compare last 3 retros` — finds recurring themes and stalled action items

## Frameworks Supported

- **Start/Stop/Continue** — classic, works for any team size
- **4Ls** — Liked, Learned, Lacked, Longed For
- **Mad/Sad/Glad** — emotional temperature check
- **Sailboat** — Wind (helps), Anchors (blockers), Rocks (risks), Island (goals)
- **DAKI** — Drop, Add, Keep, Improve

## Output Format

```markdown
# Sprint [N] Retrospective — [Date]

## Top Themes
1. [Theme] — mentioned by X people, impact: HIGH/MED/LOW

## Action Items
| # | Action | Owner | Due | Success Criteria |
|---|--------|-------|-----|------------------|
| 1 | ...    | ...   | ... | ...              |

## Patterns (vs. previous sprints)
- [Recurring issue] — appeared in 3/5 last retros
- [Improvement] — resolved since Sprint N-2
```

## Tips

- Run retros within 24 hours of sprint end while memory is fresh
- Limit to 3-5 action items per sprint — more than that and nothing gets done
- Assign every action item to ONE person (shared ownership = no ownership)
- Review previous retro actions at the start of each new retro

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI context packs for business teams. Browse all 10 industry packs at $47 each, or grab the full bundle for $197.
