# afrexai-spreadsheet-engineering

> Build bulletproof spreadsheets: financial models, dashboards, data systems, and automation. Platform-agnostic methodology for Google Sheets, Excel, and LibreOffice.

## Install

```bash
clawhub install afrexai-spreadsheet-engineering
```

## What's Inside

- **29KB** single SKILL.md — complete spreadsheet engineering methodology
- 12-phase system covering architecture → formulas → dashboards → automation
- Formula patterns library (L1-L4 complexity) with XLOOKUP, QUERY, LAMBDA, LET
- Financial modeling architecture with SaaS revenue models and scenario analysis
- Dashboard design system with KPI cards, chart selection guide, and interactive controls
- Google Apps Script and Excel VBA automation patterns
- Data validation and quality pipeline
- Performance optimization guide (volatile function elimination, bounded ranges)
- 4 ready-to-use templates (budget, project, pipeline, OKR)
- 100-point quality rubric across 8 weighted dimensions
- Platform-agnostic: works for Google Sheets, Excel 365, and LibreOffice

## Quick Start

Ask your agent:
- "Design a financial model for my SaaS business"
- "Audit this spreadsheet for quality issues"
- "Build a dashboard for tracking monthly KPIs"
- "Write a QUERY formula to aggregate sales by region"

## ⚡ Level Up

For industry-specific financial models and templates, check out our **AI Agent Context Packs** ($47 each):

👉 [**Browse All Packs →**](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-data-storytelling](https://clawhub.com/afrexai-cto/afrexai-data-storytelling) — Data visualization methodology
- [afrexai-personal-finance](https://clawhub.com/afrexai-cto/afrexai-personal-finance) — Personal finance operating system
- [afrexai-automation-strategy](https://clawhub.com/afrexai-cto/afrexai-automation-strategy) — Workflow automation
- [afrexai-fpa-engine](https://clawhub.com/afrexai-cto/afrexai-fpa-engine) — Financial planning & analysis
- [afrexai-prompt-engineering](https://clawhub.com/afrexai-cto/afrexai-prompt-engineering) — Prompt engineering mastery
