# Social Media Content Engine

Complete social media strategy, content creation, scheduling, analytics, and growth system for AI agents.

**Not just a post writer** — this is a full content machine: brand voice, audience personas, platform-specific playbooks, content calendars, repurposing workflows, analytics dashboards, and growth systems.

## Install

```bash
clawhub install afrexai-social-media-engine
```

## What's Inside

- **Brand Voice Document** — YAML template to define your tone, vocabulary, guardrails
- **5 Platform Playbooks** — Twitter/X, LinkedIn, Instagram, TikTok, Facebook with post templates, optimal times, and growth tactics
- **Content Pillar Architecture** — 6-pillar system with percentage allocation
- **Content Calendar System** — Monthly planning, weekly YAML templates, batching workflow
- **Repurposing Engine** — Turn 1 piece of content into 8+ platform-native posts
- **Hashtag Strategy** — 3-tier research system with rotation schedules
- **Engagement Routine** — Daily 30-min system for authentic growth
- **Analytics Dashboard** — Weekly metrics tracking with content scoring (0-100)
- **Crisis Management** — Response protocols and templates
- **Advanced Tactics** — Newsjacking, content series, UGC, social selling frameworks

## Quick Start

Tell your agent:
> "Create a content calendar for next week for my SaaS company on LinkedIn and Twitter"

Or:
> "Write a LinkedIn post about [topic] using the story format"

Or:
> "Set up my brand voice document and content pillars"

## ⚡ Level Up

This skill gives you the strategy engine. Want **industry-specific content angles, competitor messaging teardowns, and vertical-specific audience personas**?

Check out our Context Packs ($47 each):
- **SaaS Context Pack** — B2B content strategy, PLG messaging, churn narratives
- **Professional Services Pack** — Authority-building content, thought leadership frameworks
- **Ecommerce Pack** — Product launch sequences, UGC campaigns, seasonal calendars
- **Real Estate Pack** — Listing content, market update templates, community building

👉 [Browse all 10 packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — Find and qualify leads with 100-point scoring
- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — SEO article writing with keyword research
- [afrexai-customer-support](https://clawhub.com/skills/afrexai-customer-support) — Full support system with CSAT tracking
- [afrexai-meeting-mastery](https://clawhub.com/skills/afrexai-meeting-mastery) — Meeting prep, notes, and follow-up
- [afrexai-recruiting-engine](https://clawhub.com/skills/afrexai-recruiting-engine) — End-to-end hiring pipeline

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
