# SEO Content Engine by AfrexAI

Turn your AI agent into a complete SEO content team. Research keywords, plan content clusters, write optimized articles, and track performance — all through natural conversation.

**No API keys. No subscriptions. No code.** Just install and start creating content that ranks.

## Install

```bash
clawhub install afrexai-seo-content-engine
```

## What's Inside

- **Keyword Research Framework** — seed expansion, intent classification, competition scoring, prioritization matrix
- **Content Planning System** — briefs, content clusters, pillar-cluster architecture, editorial calendars
- **4 Article Templates** — listicles, how-to guides, comparisons, ultimate guides (with fill-in structure)
- **Writing Framework (HBCFC)** — Hook → Bridge → Core → FAQ → CTA formula for every article
- **On-Page SEO Checklist** — 25-point checklist covering title, meta, headings, content, links, schema
- **Content Scoring Rubric** — 100-point system to grade articles before publishing
- **Schema Markup Templates** — ready-to-use Article + FAQ JSON-LD
- **Advanced Techniques** — featured snippets, semantic SEO, E-E-A-T signals, freshness optimization

## Quick Start

Just tell your agent:

- "Research keywords for [your topic]"
- "Create a content brief for [keyword]"
- "Write a comparison article: [X] vs [Y]"
- "Score this article for SEO"
- "Plan a content cluster for [topic]"

## Why This Over Other SEO Skills?

| Feature | Others | AfrexAI SEO Engine |
|---------|--------|--------------------|
| Keyword research framework | ❌ Fake API calls | ✅ Real web search workflow |
| Article templates | ❌ Generic outlines | ✅ 4 fill-in templates with structure |
| Writing rules | ❌ "Write good content" | ✅ Specific sentence/paragraph/keyword rules |
| SEO checklist | ❌ Basic tips | ✅ 25-point pre-publish checklist |
| Content scoring | ❌ None | ✅ 100-point rubric |
| Schema markup | ❌ Mentioned | ✅ Copy-paste JSON-LD templates |
| Content clusters | ❌ Not covered | ✅ Pillar + cluster architecture |
| Works without APIs | ❌ Requires subscriptions | ✅ Zero dependencies |

## ⚡ Level Up

Want industry-specific content strategies, competitor landscapes, and outreach sequences? Check out our **AI Agent Context Packs** — deep vertical intelligence for your agents:

- [SaaS Context Pack](https://afrexai-cto.github.io/context-packs/) — $47
- [Professional Services Pack](https://afrexai-cto.github.io/context-packs/) — $47
- [Ecommerce Context Pack](https://afrexai-cto.github.io/context-packs/) — $47

Each pack includes market analysis, competitor profiles, pricing strategies, and ready-to-use agent prompts for your vertical.

## 🔗 More Free Skills by AfrexAI

- `afrexai-lead-hunter` — Find and qualify leads with scoring rubrics
- `afrexai-budget-tracker` — Personal/business finance tracking
- `afrexai-email-to-calendar` — Extract events from emails automatically
- `afrexai-humanizer` — Remove AI-speak from any content
- `afrexai-prospect-researcher` — Deep company research for sales

👉 [Browse all AfrexAI skills on ClawHub](https://clawhub.com)
👉 [AfrexAI Storefront](https://afrexai-cto.github.io/context-packs/)

---

*Built by AfrexAI 🖤💛 — AI agent infrastructure for businesses that ship.*
