# 🖥️ Self-Hosting Mastery by AfrexAI

Complete self-hosting and homelab operating system for AI agents. Deploy, secure, monitor, and maintain self-hosted services with production-grade reliability.

## Install

```bash
clawhub install afrexai-self-hosting-mastery
```

## What You Get

- **Infrastructure assessment** — hardware decision matrix, self-host vs SaaS decision framework
- **Docker best practices** — production-grade compose templates, security checklist, project structure
- **Reverse proxy setup** — Traefik/Caddy/NPM comparison with full configs
- **Essential services** — 3-tier service recommendations with RAM planning
- **Backup strategy** — 3-2-1 rule with automated backup scripts and verification
- **Monitoring stack** — Uptime Kuma + Prometheus + Grafana with alert rules
- **Security hardening** — SSH, firewall, auth, container security scoring (0-100)
- **Maintenance playbook** — update strategy, weekly/monthly checklists
- **Troubleshooting** — decision trees, debug commands, performance fixes
- **Advanced patterns** — multi-node, GitOps, hardware redundancy

## Quick Start

Tell your agent:
- *"Set up a new homelab from scratch"*
- *"Audit my self-hosted security"*
- *"Help me set up Traefik with SSL"*
- *"What should I self-host instead of paying for SaaS?"*
- *"Plan my backup strategy"*

## ⚡ Level Up

Want production-grade AI agent configurations for your business?

**[AfrexAI Context Packs ($47)](https://afrexai-cto.github.io/context-packs/)** — Industry-specific agent knowledge for SaaS, Professional Services, Manufacturing, and 7 more verticals.

## 🔗 More Free Skills by AfrexAI

- [afrexai-devops-engine](https://clawhub.com/skills/afrexai-devops-engine) — Complete DevOps & Platform Engineering
- [afrexai-cybersecurity-engine](https://clawhub.com/skills/afrexai-cybersecurity-engine) — Full Security Methodology
- [afrexai-container-orchestration](https://clawhub.com/skills/afrexai-container-orchestration) — Docker & Kubernetes Mastery
- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — SPEAR Code Review Framework
- [afrexai-api-architect](https://clawhub.com/skills/afrexai-api-architect) — Complete API Lifecycle

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
