# B2B Sales Playbook ⚡

**The complete system for running a repeatable B2B sales operation — from ICP to closed-won.**

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — the team that builds AI agent skills that actually work.

## What This Does

Turn your AI agent into a B2B sales co-pilot that helps you:

- **Define your ICP** with anti-signals and buyer personas
- **Run multi-channel prospecting** with proven email/call/LinkedIn sequences
- **Qualify deals** using MEDDPICC (scored, not guesswork)
- **Handle objections** with the LAER framework + 15 scripted rebuttals
- **Manage your pipeline** with stage exit criteria and forecast categories
- **Close deals** with 4 closing techniques + negotiation rules
- **Expand accounts** with post-sale signals and upsell playbooks

## Install

```bash
clawhub install afrexai-sales-playbook
```

## Quick Start

After installing, try:

- `"Build my ICP"` — Define your ideal customer with scoring
- `"Write outreach for [company]"` — Get a personalized sequence
- `"Qualify this deal"` — MEDDPICC assessment with score
- `"Review my pipeline"` — Weekly pipeline health check
- `"Coach me on this call"` — Get feedback on a sales conversation

## What's Inside

- 10-phase sales methodology (ICP → Expansion)
- MEDDPICC qualification framework with YAML templates
- 3 cold email templates + cold call script with rebuttals
- Discovery question bank (22 questions across 5 categories)
- Objection handling playbook (15+ scripted responses)
- Pipeline stage definitions with exit criteria
- Forecast framework (Commit/Best Case/Pipeline/Upside)
- Win/loss analysis template
- Mutual Action Plan (MAP) template
- Deal handoff template for Customer Success
- Expansion revenue playbook with signals
- Activity + outcome metrics with healthy ranges

## ⚡ Level Up

Love this skill? Our **$47 Context Packs** give your agent deep industry expertise:

- **SaaS Context Pack** — SaaS-specific sales motions, PLG vs sales-led, expansion metrics
- **Professional Services Pack** — Consultative selling, SOW structures, utilization targets
- **Fintech Context Pack** — Compliance-aware selling, bank partnerships, API-first GTM

👉 [Browse all 10 industry packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — ICP-based lead generation & enrichment
- [afrexai-proposal-engine](https://clawhub.com/skills/afrexai-proposal-engine) — Deal-winning proposal methodology
- [afrexai-negotiation-mastery](https://clawhub.com/skills/afrexai-negotiation-mastery) — 7-phase negotiation system
- [afrexai-competitive-intel](https://clawhub.com/skills/afrexai-competitive-intel) — Competitive intelligence & battlecards
- [afrexai-email-marketing-engine](https://clawhub.com/skills/afrexai-email-marketing-engine) — Cold + warm email system

---

Built with 🖤💛 by AfrexAI
