# Sales Compensation Plan Designer

Design, audit, and optimize sales compensation structures that actually drive the behavior you want. Covers quota setting, OTE splits, accelerators, clawbacks, SPIFs, and multi-role plan architectures.

## When to Use
- Designing comp plans for new sales roles (AE, SDR, CSM, SE, Channel)
- Auditing existing plans for misaligned incentives
- Modeling plan costs and quota coverage ratios
- Building accelerator/decelerator curves
- Comparing comp structures across industry benchmarks

## Compensation Plan Framework

### Step 1: Role Classification
Classify the role before designing comp:

| Role Type | Typical OTE | Base/Variable Split | Quota Multiple |
|-----------|-------------|--------------------:|----------------|
| SDR/BDR | $65K-$90K | 70/30 | 3-5x variable |
| AE (SMB) | $100K-$140K | 50/50 | 4-6x OTE |
| AE (Mid-Market) | $150K-$200K | 50/50 | 4-5x OTE |
| AE (Enterprise) | $200K-$300K+ | 60/40 | 3-4x OTE |
| CSM/AM | $90K-$130K | 65/35 | 4-6x variable |
| Sales Engineer | $130K-$180K | 70/30 | Team-based |
| VP Sales | $250K-$400K+ | 55/45 | 2-3x OTE |
| Channel/Partner | $120K-$160K | 60/40 | 3-5x variable |

### Step 2: Quota Setting Methodology
Use bottom-up capacity model:

1. **TAM Analysis** — addressable market in territory
2. **Historical Performance** — trailing 4-quarter attainment distribution
3. **Ramp Adjustment** — new hires at 25/50/75/100% quota months 1-4
4. **Coverage Ratio** — pipeline-to-quota (3x minimum for new business, 2x for expansion)
5. **Quota:OTE Ratio** — should be 4-6x. Below 3x = overpaying. Above 8x = nobody hits it.

Red flags in quota setting:
- Top-down only (board target ÷ headcount)
- Same quota for all territories regardless of TAM
- No ramp period for new hires
- Changing quotas mid-quarter
- More than 60% of reps missing quota (plan problem, not people problem)

### Step 3: Variable Compensation Design

**Base Structure:**
```
Monthly Variable = (Attainment % × Quota × Commission Rate)
```

**Accelerator Tiers (recommended):**
| Attainment | Rate Multiplier | Rationale |
|------------|---------------:|-----------|
| 0-50% | 0.5x | Below threshold — reduced payout |
| 50-80% | 0.8x | Approaching target — building momentum |
| 80-100% | 1.0x | At plan — full commission rate |
| 100-120% | 1.3x | Above plan — reward overperformance |
| 120-150% | 1.5x | President's Club territory |
| 150%+ | 1.8-2.0x | Uncapped or soft cap (model both) |

**Commission Rate Benchmarks:**
- New Business: 8-12% of ACV
- Expansion/Upsell: 4-8% of ACV
- Renewal: 1-3% of ACV
- Multi-year: 1.2-1.5x first-year rate

### Step 4: Plan Component Mix
For complex plans, weight components:

| Component | Weight | Metric |
|-----------|-------:|--------|
| New Logo Revenue | 50-60% | New ACV closed |
| Expansion Revenue | 20-30% | Net expansion ACV |
| Strategic Objective | 10-20% | Product mix, multi-year, strategic accounts |
| Activity Metrics | 0-10% | Pipeline generated (SDRs only) |

Rule: Never more than 3 variable components. Complexity kills motivation.

### Step 5: Clawback and Recovery Provisions
Standard terms:
- **Churn clawback**: Pro-rata recovery if customer churns within 6-12 months
- **Non-payment clawback**: Commission reversed if invoice unpaid >90 days
- **Early termination**: Unvested accelerators forfeit on voluntary departure
- **Draw recovery**: Unearned draws recovered from future commissions (max 2 quarters)

### Step 6: SPIF Design (Short-term Incentive)
Use SPIFs for 2-4 week behavioral nudges:
- New product launch push ($500-$2,000 per deal)
- Quarter-end pipeline acceleration
- Competitive displacement bonus
- Multi-year contract premium

SPIF rules:
- Max 4 per year (they lose impact if constant)
- Clear start/end dates
- Simple qualification (one metric)
- Immediate payout (within 2 weeks of close)

### Step 7: Plan Cost Modeling
Model these scenarios before launching:

1. **Bear case**: 40% of reps at 80% attainment → total comp cost
2. **Base case**: 60% at quota, 20% above, 20% below → total comp cost
3. **Bull case**: 80% at 110%+ attainment → total comp cost (check for budget blow-up)

**Healthy ratios:**
- Sales comp as % of revenue: 15-25% (SaaS)
- CAC payback: <18 months
- Quota:OTE: 4-6x
- Rep productivity: >$500K ACV/AE/year at maturity

### Step 8: Annual Plan Audit Checklist

Score each item 1-10:

1. ☐ Quota attainment distribution (bell curve centered at 100%?)
2. ☐ Voluntary turnover of quota-carrying reps (<15%?)
3. ☐ Time-to-ramp for new hires (meeting benchmark?)
4. ☐ Deal size trends (growing or shrinking?)
5. ☐ Discount depth (comp plan driving discounting?)
6. ☐ Multi-year mix (incentive working?)
7. ☐ Product mix (strategic products getting traction?)
8. ☐ Comp cost as % of revenue (in healthy range?)
9. ☐ Accelerator payouts (are top reps being rewarded enough?)
10. ☐ Clawback frequency (too high = bad customers, too low = loose terms)

**Score interpretation:**
- 80-100: Plan is working. Minor tweaks only.
- 60-79: 2-3 components need redesign.
- Below 60: Full plan overhaul needed.

## 2026 Benchmarks by Industry

| Industry | Avg AE OTE | Base/Var | Quota:OTE | Avg Attainment |
|----------|-----------|----------|-----------|----------------|
| SaaS | $165K | 50/50 | 5x | 62% |
| Fintech | $185K | 55/45 | 4.5x | 58% |
| Healthcare IT | $155K | 55/45 | 5x | 65% |
| Cybersecurity | $175K | 50/50 | 4x | 60% |
| AI/ML | $190K | 50/50 | 4x | 55% |
| Legal Tech | $145K | 55/45 | 5.5x | 68% |
| Construction Tech | $135K | 55/45 | 6x | 70% |
| Manufacturing | $140K | 60/40 | 5.5x | 67% |
| Professional Services | $150K | 55/45 | 5x | 64% |
| Real Estate Tech | $130K | 55/45 | 6x | 72% |

## Common Mistakes

1. **Capping commissions** — your best reps will leave for uncapped plans
2. **Quarterly resets with no floor** — creates sandbagging and feast/famine
3. **Too many metrics** — if reps can't calculate their own comp, the plan fails
4. **Equal quotas across unequal territories** — punishes reps in harder markets
5. **Changing plans mid-year** — destroys trust faster than anything else
6. **No accelerators** — linear plans don't motivate above-quota performance
7. **Ignoring ramp periods** — new hire attrition spikes when they can't earn early

## AI-Era Adjustments (2026+)

Sales teams using AI agents for prospecting, qualification, and proposal generation are seeing:
- 30-40% increase in rep capacity (more pipeline per AE)
- SDR role compression (AI handles top-of-funnel → SDR quotas need restructuring)
- Faster ramp times (AI-assisted onboarding cuts ramp by 30-45 days)
- Higher quota expectations (adjust gradually — 10-15% annual increase, not 40% overnight)

Comp plan implications:
- Shift SDR comp toward quality metrics (SQL conversion, not just meetings booked)
- Add AI adoption component (5-10% of variable tied to tool utilization)
- Model higher quotas with maintained OTE — don't cut OTE when raising quotas
- Budget for AI tooling ($200-$500/rep/month) as sales cost, not IT cost

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI context packs for businesses that ship.*

Get your industry-specific AI strategy pack: **https://afrexai-cto.github.io/context-packs/** ($47/pack)

Calculate your AI revenue leak: **https://afrexai-cto.github.io/ai-revenue-calculator/**
