# Roofing Contractor Operations

Your agent becomes a roofing business operations expert — estimating, materials, crew management, insurance claims, licensing, safety compliance, and growth strategy.

## What This Covers

### Estimating & Pricing
| Roof Type | Material $/sq (100 sqft) | Labor $/sq | Total Installed $/sq | Typical Warranty |
|-----------|-------------------------|------------|---------------------|-----------------|
| 3-Tab Asphalt | $90-120 | $75-100 | $350-500 | 20-25 yr |
| Architectural Shingle | $120-180 | $85-120 | $400-650 | 30-50 yr |
| Standing Seam Metal | $350-600 | $200-350 | $800-1,400 | 40-60 yr |
| TPO (Commercial) | $180-280 | $150-250 | $500-900 | 15-25 yr |
| EPDM Rubber | $150-250 | $120-200 | $400-700 | 20-30 yr |
| Clay Tile | $400-700 | $300-500 | $1,000-1,800 | 50-100 yr |
| Slate | $600-1,500 | $400-700 | $1,500-3,500 | 75-200 yr |
| Modified Bitumen | $200-350 | $150-250 | $500-800 | 15-20 yr |

### Measurement & Waste Factors
- Simple gable: 5-10% waste factor
- Hip roof: 10-15% waste
- Complex/cut-up: 15-20% waste
- Valleys, dormers, skylights: add 5-10% each
- Pitch multiplier: 4/12=1.054, 6/12=1.118, 8/12=1.202, 10/12=1.302, 12/12=1.414

### Insurance Storm Damage Claims
| Damage Type | Signs | Typical Approval Rate |
|-------------|-------|----------------------|
| Hail (>1" diameter) | Bruised shingles, dented vents, cracked tiles | 75-85% |
| Wind (60+ mph) | Lifted/missing shingles, exposed underlayment | 70-80% |
| Fallen tree/debris | Impact marks, punctures, structural damage | 85-95% |
| Ice dam | Water stains inside, damaged soffit/fascia | 50-60% |

**Supplement process:** Initial scope → missed items identified → supplement filed → adjuster re-inspection → revised estimate. Average supplement adds 20-40% to initial approved amount.

### OSHA Safety Compliance
| Violation | OSHA Fine (2026) | Prevention |
|-----------|-----------------|------------|
| No fall protection (>6 ft) | $16,131 per | Harness + anchor + guardrails mandatory |
| No training documentation | $16,131 per | Weekly toolbox talks, signed attendance |
| Ladder violations | $16,131 per | 3-point contact, 3ft extension above roof |
| Willful violation | $161,323 per | Immediate program overhaul |
| Repeat violation | $161,323 per | Root cause + corrective action plan |

Fall protection required at 6 feet in construction (29 CFR 1926.501). #1 cited OSHA violation every year.

### Licensing by State (Sample)
| State | License Required | Exam | Bond | Insurance Min |
|-------|-----------------|------|------|---------------|
| Florida | CCC (Certified) or CRC (Registered) | Yes — trade + business | $25K | $300K GL + WC |
| Texas | None statewide (city-level) | Varies | Varies | Varies by city |
| California | C-39 Roofing | Yes — law + trade | $25K | $1M GL + WC |
| Georgia | Residential: none <$2,500 | No | No | Recommended |
| New York | NYC: LMP required | Yes | $50K | $1M GL + WC |
| Illinois | State roofing license | Yes | $10K | $500K GL + WC |

### Crew Production Rates
| Task | Crew Size | Production/Day | Notes |
|------|-----------|---------------|-------|
| Tear-off (1 layer asphalt) | 4-person | 25-35 squares | Dumpster positioned close |
| Shingle install (architectural) | 4-person | 15-25 squares | Weather dependent |
| Metal panel install | 3-person | 8-12 squares | Precision cuts slow pace |
| Flat roof (TPO weld) | 3-person | 10-15 squares | Seam welding bottleneck |
| Gutter install | 2-person | 150-200 LF | Seamless machine on-site |
| Flashing/detail work | 2-person | Varies | Most callback-prone area |

### Financial Benchmarks
| Metric | Target | Red Flag |
|--------|--------|----------|
| Gross margin | 40-50% | Below 30% |
| Net profit | 8-15% | Below 5% |
| Close rate | 35-45% | Below 25% |
| Average job size (residential) | $8,000-15,000 | Below $5,000 |
| Average job size (commercial) | $25,000-100,000+ | Below $15,000 |
| Revenue per employee | $150K-250K | Below $100K |
| Warranty callback rate | <3% | Above 5% |
| Customer acquisition cost | $250-500 | Above $750 |
| Lead-to-close cycle | 7-14 days | Above 30 days |

### Growth Playbook
**$0-$500K (Year 1-2):**
- Owner + 1-2 crews, 1 admin
- Focus: residential re-roofs, storm damage
- Marketing: door knocking after storms, Google Business Profile, yard signs
- Software: JobNimbus or AccuLynx for CRM + job tracking

**$500K-$2M (Year 2-4):**
- 3-5 crews, dedicated sales rep, office manager
- Add commercial/multi-family
- Insurance restoration becomes major revenue (40-60%)
- Marketing: SEO, Google Ads ($15-40/click for "roofing contractor near me")
- Hire production manager — owner exits daily field work

**$2M-$5M+ (Year 4-7):**
- 8-12 crews, sales team, project managers
- Service department (repairs, maintenance contracts)
- Manufacturer certifications (GAF Master Elite, Owens Corning Platinum)
- Expansion: adjacent markets, additional service areas
- Consider franchise model or acquisitions

### Seasonal Revenue Pattern (US Average)
| Month | Revenue Index | Notes |
|-------|--------------|-------|
| Jan | 40% | Slow — emergency repairs only in North |
| Feb | 45% | Pre-season planning, trade shows |
| Mar | 65% | Season starting, inspections increase |
| Apr | 85% | Spring storm season begins |
| May | 100% | Peak season starts |
| Jun | 110% | Peak — longest days, best weather |
| Jul | 105% | Peak continues, heat slows Southern crews |
| Aug | 100% | Late summer push |
| Sep | 95% | Fall rush before winter |
| Oct | 80% | Last push in Northern markets |
| Nov | 55% | Winding down, winterization |
| Dec | 35% | Slowest — focus on planning, training |

### Insurance Requirements
- **General Liability:** $1M-2M (required everywhere, non-negotiable)
- **Workers' Comp:** Required in 48 states (TX/OK optional but recommended)
- **Commercial Auto:** $1M combined single limit
- **Inland Marine/Tools:** $50K-200K for equipment on trucks
- **Umbrella:** $1M-5M (required for commercial contracts)
- **WC rates:** Roofing is Class Code 5551 — rates $15-45 per $100 payroll (highest in construction)

## When To Use This Skill
- Estimating a roofing job (residential or commercial)
- Understanding material options and pricing
- Filing or supplementing insurance claims
- OSHA compliance and safety program setup
- Licensing requirements for new markets
- Crew productivity planning
- Financial benchmarking and growth strategy
- Seasonal cash flow planning

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI operations packs for every industry. Get the full Construction Context Pack ($47) with estimating templates, compliance checklists, and crew management tools at our [storefront](https://afrexai-cto.github.io/context-packs/).*
