# AfrexAI Enterprise Risk Management Engine

Complete 10-phase enterprise risk management system for AI agents. Identify, assess, mitigate, and monitor risks across all categories — operational, financial, strategic, compliance, cyber, and reputational.

## What This Skill Does

Turns your AI agent into a risk management specialist that can:

- **Map your entire risk universe** across 8 categories with 50+ sub-risks
- **Score risks** using industry-standard 5×5 likelihood × impact matrix
- **Design controls** using defense-in-depth and four control types
- **Build KRI dashboards** with 30+ pre-built indicators and RAG thresholds
- **Run scenario analysis** with 6 pre-built stress test scenarios
- **Generate board-ready risk reports** with heatmaps and trend analysis
- **Create business continuity plans** with BIA, RTO/RPO, and crisis response
- **Assess risk culture** and governance maturity

## Install

```bash
clawhub install afrexai-risk-management
```

## Quick Start

```
"Build a risk register for my SaaS startup"
"Assess the risk of expanding into the EU market"
"Design KRIs for our cybersecurity program"
"Run a scenario analysis for a key customer loss"
"Draft a quarterly board risk report"
```

## What's Inside

| Phase | What You Get |
|-------|-------------|
| Context Setting | Risk appetite framework, tolerance levels by category |
| Identification | 8-category risk universe, 50+ sub-risks, 8 identification methods |
| Assessment | 5×5 matrix, velocity scoring, interconnection mapping |
| Treatment | 4-strategy decision framework, control design, cost-benefit analysis |
| KRI Monitoring | 30+ pre-built KRIs with thresholds, dashboard template |
| Scenario Analysis | 6 pre-built scenarios, stress test methodology, Monte Carlo |
| Reporting | Board report structure, monthly management template |
| Business Continuity | BIA template, crisis response framework, communication templates |
| Governance | Three Lines of Defense, risk culture assessment, annual calendar |
| Advanced | Quantitative analysis, bow-tie method, risk-adjusted decisions |

## ⚡ Level Up

Want industry-specific risk registers, KRIs, and compliance checklists pre-built for your sector?

**AfrexAI Context Packs** — $47 each with deep risk frameworks for Healthcare, Fintech, Legal, Construction, SaaS, Manufacturing, and more.

👉 [Browse Context Packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- `afrexai-contract-review` — Legal contract review with risk scoring
- `afrexai-competitive-intel` — Competitive intelligence system
- `afrexai-fpa-engine` — Financial planning & analysis
- `afrexai-founder-os` — Startup operating system
- `afrexai-customer-success` — Customer success & retention

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
