# Risk Assessment Framework

Turn uncertainty into a scored, prioritized action plan. This skill runs a structured risk assessment on any business, project, or strategic decision — producing a board-ready risk register with mitigation strategies.

## Why This Exists

Most teams identify risks informally ("we should probably worry about X"). This skill forces rigor: every risk gets a Likelihood × Impact score, a category, a mitigation plan, an owner, and a deadline.

The output works for:
- **Board meetings** — Professional risk register format
- **Project kickoffs** — Identify blockers before they hit
- **Due diligence** — Vendor, M&A, or investment assessment
- **Compliance** — SOC 2, ISO 27001, GDPR risk documentation
- **Insurance** — Demonstrate risk management maturity

## How It Works

1. Describe what you're assessing
2. The agent identifies risks across 6 categories
3. Each risk gets scored on a 25-point matrix
4. Risks are heat-mapped: 🔴 Critical → 🟢 Low
5. Mitigation strategies generated with cost estimates
6. Residual risk scored after mitigation

## Categories

| Category | Examples |
|----------|----------|
| Operational | Process failures, key person dependency, supply chain |
| Financial | Cash flow, currency exposure, pricing pressure |
| Technical | Security breaches, system downtime, tech debt |
| Regulatory | GDPR fines, licensing changes, tax law shifts |
| Reputational | PR incidents, customer churn, Glassdoor reviews |
| Strategic | Market shifts, competitor moves, partnership risks |

## Installation

```bash
clawhub install afrexai-risk-assessment
```

## Goes Well With

- [Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Quantify what risk costs your business
- [AI Context Packs](https://afrexai-cto.github.io/context-packs/) — Industry-specific risk libraries ($47/pack)
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Get your AI agent running in minutes

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
