# RFP & Proposal Responder

Turn RFPs, RFIs, and proposal requests into winning responses. Fast.

## What It Does

Takes an RFP document (or key requirements) and generates a structured proposal response with:

- **Executive Summary** — why you're the right fit, in 3 sentences
- **Requirements Matrix** — every requirement mapped to your capability + evidence
- **Pricing Section** — structured options (good/better/best) with clear deliverables
- **Risk Mitigation** — proactive answers to "what could go wrong"
- **Timeline** — realistic milestones with dependencies called out
- **Differentiators** — what makes your bid stand out vs. generic competitors

## Usage

Paste the RFP text or key requirements, then tell the agent:

```
Here's the RFP: [paste text or attach file]

Our company: [brief description]
Our strengths: [2-3 key differentiators]
Budget range: [if known]
```

The agent will produce a complete draft response ready for review and submission.

## Tips

- Include your past win examples — the agent weaves them into proof points
- Specify word/page limits if the RFP has them
- Ask for a "compliance checklist" first if the RFP is complex
- Use "score my response" to get a self-assessment before submitting

## Who This Is For

- Agencies responding to government or enterprise RFPs
- B2B service companies competing for contracts
- Consultancies that burn 20+ hours per proposal

## Go Deeper

- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — find where you're losing money before the next bid
- [AI Context Packs](https://afrexai-cto.github.io/context-packs/) — industry-specific agent configurations ($47/pack)
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — get your AI agent configured in 5 minutes
