# AfrexAI Revenue Operations Engine

The complete RevOps system for aligning marketing, sales, and customer success into a unified revenue machine. Shared data, shared processes, shared goals — no more silos.

## What This Does

- **RevOps maturity assessment** with 6-dimension scoring model
- **Unified funnel architecture** with cross-team definitions and SLAs
- **Pipeline management** with coverage models, velocity formulas, and forecast methodology
- **Revenue metrics dashboard** — board metrics, operating metrics, and diagnostic metrics with B2B SaaS benchmarks
- **GTM efficiency analysis** — CAC, LTV, magic number, burn multiple by ACV tier
- **Lead scoring and routing** with behavioral + firmographic signals
- **Compensation and territory design** templates
- **Tech stack integration** roadmap by company stage
- **Annual revenue planning** with scenario modeling
- **Advanced patterns** — PLG hybrid, cohort analysis, revenue intelligence signals

## Install

```bash
clawhub install afrexai-revops-engine
```

## Quick Start

> "Audit our RevOps maturity — we're a $3M ARR B2B SaaS with 5 AEs, HubSpot CRM, and our marketing team says sales ignores their leads."

The skill walks through the full maturity assessment, identifies your bottleneck (likely the marketing-sales SLA gap), and generates actionable templates.

## What's Inside

- 14-phase complete RevOps methodology
- Funnel stage definitions with conversion benchmarks
- Lead scoring model with behavioral + firmographic signals
- Pipeline coverage calculator with healthy ratios
- Revenue metrics dashboard YAML (Tier 1/2/3)
- Marketing ↔ Sales ↔ CS SLA templates
- Forecast methodology with MAPE tracking
- Compensation plan architecture by role
- Territory design framework
- Tech stack recommendations by ARR stage
- Revenue planning model with scenario analysis
- Expansion signal detection system
- 100-point quality rubric
- 12 natural language commands

## ⚡ Level Up

This skill gives you the RevOps framework. For industry-specific revenue playbooks with vertical benchmarks, competitive landscapes, and tailored metrics:

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)**

- **SaaS Context Pack** — SaaS-specific RevOps with PLG metrics, cohort benchmarks, and expansion playbooks
- **Fintech Context Pack** — Compliance-aware revenue ops for regulated financial services
- **Professional Services Context Pack** — Utilization-based revenue models and project-to-revenue tracking

## 🔗 More Free Skills by AfrexAI

- [afrexai-sales-playbook](https://clawhub.com/skills/afrexai-sales-playbook) — Complete B2B sales system (MEDDPICC, objection handling, closing)
- [afrexai-customer-success](https://clawhub.com/skills/afrexai-customer-success) — Health scoring, churn prevention, expansion revenue
- [afrexai-fpa-engine](https://clawhub.com/skills/afrexai-fpa-engine) — Financial planning & analysis with unit economics
- [afrexai-growth-engine](https://clawhub.com/skills/afrexai-growth-engine) — Growth loops, experiments, NSM framework
- [afrexai-pricing-strategy](https://clawhub.com/skills/afrexai-pricing-strategy) — Value-based pricing, tier design, price increase playbooks

**Browse all AfrexAI skills →** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
