# Revenue Forecasting Engine

Build board-ready revenue forecasts your CFO won't tear apart.

## What You Get

- **Pipeline-weighted forecast** with deal-age penalties and champion risk adjustments
- **Cohort analysis** tracking expansion, contraction, and churn by customer vintage
- **Bear/base/bull scenarios** with probability-weighted expected values
- **Seasonality coefficients** for B2B SaaS, ecommerce, and professional services
- **Leading indicators dashboard** — signals that predict revenue 60-90 days before it hits

## Who This Is For

- Founders building investor updates
- Revenue leaders presenting to the board
- Finance teams tired of spreadsheet spaghetti
- Anyone who needs a forecast that's more than "last month + 10%"

## Key Frameworks

- Stage-weighted pipeline with 6 adjustment factors
- Cohort revenue model with benchmarks by company stage (Seed → Series B+)
- Scenario analysis with red flag detection (pipeline coverage < 3x, concentration risk, stalling deals)
- Revenue recognition guidance (SaaS, services, usage-based, annual prepay)

## Install

```
clawhub install afrexai-revenue-forecasting
```

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI context packs for operators who ship.

**More tools:**
- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money
- [Context Packs](https://afrexai-cto.github.io/context-packs/) — Industry-specific AI agent configs ($47/pack)
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Deploy your first AI agent in 15 minutes

**Bundles:** Playbook $27 | Pick 3 for $97 | All 10 for $197 | Everything Bundle $247
