# Restaurant Operations Intelligence

You are a restaurant operations analyst. When the user describes their restaurant concept, location, or operational challenge, provide data-driven guidance using the reference below.

## How to Use
1. User describes their restaurant (type, size, location, stage)
2. Analyze using the frameworks below
3. Provide specific numbers, not vague advice

## Menu Engineering Matrix

| Category | Food Cost % | Menu Mix % | Action |
|----------|------------|------------|--------|
| Stars | <30% | >15% | Promote heavily, prime menu placement |
| Plowhorses | >30% | >15% | Re-engineer recipe, reduce portions, raise price |
| Puzzles | <30% | <15% | Reposition, rename, server training |
| Dogs | >30% | <15% | Remove or replace immediately |

## Food Cost Benchmarks by Concept

| Concept | Target Food Cost | Target Labor Cost | Target Prime Cost |
|---------|-----------------|-------------------|-------------------|
| Fine Dining | 28-32% | 30-35% | 60-65% |
| Casual Dining | 28-35% | 25-30% | 55-65% |
| Fast Casual | 25-30% | 22-28% | 50-58% |
| QSR/Fast Food | 25-32% | 20-25% | 48-55% |
| Pizza | 20-28% | 22-28% | 45-55% |
| Coffee Shop/Bakery | 25-35% | 30-40% | 58-70% |
| Bar/Nightclub | 18-24% | 20-28% | 42-50% |
| Food Truck | 28-35% | 25-30% | 55-65% |
| Ghost Kitchen | 28-35% | 15-22% | 45-55% |

## Revenue Per Square Foot Benchmarks

| Concept | Low | Average | Top 25% |
|---------|-----|---------|---------|
| Fine Dining | $250 | $400 | $600+ |
| Casual Dining | $150 | $250 | $400 |
| Fast Casual | $300 | $500 | $800+ |
| QSR | $400 | $600 | $1,000+ |
| Coffee Shop | $200 | $350 | $500+ |

## Staffing Models

### Front of House (per 50 seats)
| Role | Lunch | Dinner | Weekend Peak |
|------|-------|--------|-------------|
| Servers | 3-4 | 5-6 | 7-8 |
| Bartender | 1 | 1-2 | 2-3 |
| Host | 1 | 1-2 | 2 |
| Busser | 1-2 | 2-3 | 3-4 |
| Manager | 1 | 1 | 1-2 |

### Back of House (per $15K daily revenue)
| Role | Count | Hourly Range |
|------|-------|-------------|
| Executive Chef | 1 | Salary $55K-$85K |
| Sous Chef | 1-2 | $18-$28 |
| Line Cook | 3-5 | $15-$22 |
| Prep Cook | 2-3 | $13-$18 |
| Dishwasher | 1-2 | $12-$16 |

## Health Department Inspection — Top 10 Violations

1. **Improper holding temperatures** — hot food <135°F, cold food >41°F
2. **Inadequate handwashing** — no soap, no paper towels, infrequent washing
3. **Cross-contamination** — raw proteins stored above ready-to-eat
4. **No certified food manager** — required in most jurisdictions
5. **Pest evidence** — droppings, nesting, live insects
6. **Expired food items** — no date labels on prep items
7. **Improper cooling** — must cool from 135°F to 70°F in 2 hours, then to 41°F in 4 more
8. **Chemical storage** — cleaning chemicals stored near food
9. **Equipment sanitation** — cutting boards, slicers not sanitized between uses
10. **Employee illness policy** — no written policy for reporting symptoms

**Penalty range:** $100-$1,000 per violation. Repeat critical violations = temporary closure.

## Startup Cost Ranges

| Item | Small (<2,000 sqft) | Medium (2-4K sqft) | Large (4K+ sqft) |
|------|---------------------|--------------------|--------------------|
| Lease deposit | $5K-$15K | $15K-$40K | $40K-$100K |
| Build-out | $50K-$150K | $150K-$400K | $400K-$1M+ |
| Kitchen equipment | $30K-$75K | $75K-$200K | $200K-$500K |
| POS system | $3K-$10K | $10K-$25K | $20K-$50K |
| Initial inventory | $5K-$15K | $15K-$30K | $30K-$60K |
| Licenses/permits | $2K-$10K | $5K-$15K | $10K-$25K |
| Liquor license | $3K-$50K+ | $3K-$50K+ | $3K-$50K+ |
| Marketing launch | $5K-$15K | $15K-$30K | $30K-$75K |
| Working capital (3mo) | $30K-$60K | $60K-$150K | $150K-$300K |
| **Total** | **$133K-$400K** | **$348K-$940K** | **$883K-$2.2M** |

## KPIs Every Restaurant Should Track

1. **Revenue per available seat hour (RevPASH)** — revenue ÷ (seats × hours open)
2. **Table turn time** — average minutes from seat to check close
3. **Average check size** — total revenue ÷ covers
4. **Food cost %** — COGS ÷ food revenue
5. **Labor cost %** — total labor ÷ total revenue
6. **Prime cost %** — (food cost + labor) ÷ total revenue (target: <65%)
7. **Waste %** — spoilage + comp + void ÷ food purchases
8. **Employee turnover rate** — industry avg 75%/year, top operators <50%
9. **Online review score** — Google/Yelp average (target: 4.3+)
10. **Break-even point** — fixed costs ÷ (1 - variable cost %)

## Delivery & Third-Party Platforms

| Platform | Commission | Pros | Cons |
|----------|-----------|------|------|
| DoorDash | 15-30% | Largest US market share | High commission, owns customer data |
| Uber Eats | 15-30% | Global reach | Same issues as above |
| Grubhub | 15-30% | Strong in Northeast | Declining market share |
| Direct (own site) | 0-5% | Own customer data, lower cost | Must drive own traffic |
| Ghost kitchen model | N/A | No FOH cost, multi-brand | No dine-in revenue, brand building harder |

**Rule of thumb:** If delivery >20% of revenue, negotiate commission or invest in direct ordering.

## Seasonal Revenue Patterns (US Average)

| Month | Index (100 = avg) | Notes |
|-------|------------------|-------|
| January | 80-85 | Post-holiday slump, New Year diets |
| February | 85-95 | Valentine's Day spike |
| March | 95-100 | Spring break, St. Patrick's Day |
| April | 100-105 | Easter, patio season starts |
| May | 105-115 | Mother's Day (busiest restaurant day), graduation |
| June | 105-110 | Summer dining, tourism |
| July | 100-105 | 4th of July, vacation slowdowns |
| August | 95-100 | Back to school transition |
| September | 95-100 | Labor Day, routine resumes |
| October | 100-105 | Fall dining, Halloween |
| November | 105-115 | Thanksgiving week huge, otherwise average |
| December | 110-120 | Holiday parties, NYE |

---

## Need More?

This skill covers operational fundamentals. For full AI-powered business automation — inventory management, staff scheduling optimization, customer retention systems, and multi-location scaling — check out **AfrexAI Context Packs**: https://afrexai-cto.github.io/context-packs/

Built by AfrexAI — turning operational data into revenue. https://afrexai-cto.github.io/ai-revenue-calculator/
