# Restaurant Operations Intelligence 🍽️

Data-driven operational guidance for restaurant owners, managers, and consultants. Covers every concept from food trucks to fine dining.

## What's Inside

- **Menu Engineering Matrix** — classify every item as Star, Plowhorse, Puzzle, or Dog
- **Food Cost Benchmarks** — target percentages by concept (QSR, casual, fine dining, ghost kitchen)
- **Revenue Per Square Foot** — know if your space is underperforming
- **Staffing Models** — FOH and BOH headcount by volume
- **Health Inspection Prep** — top 10 violations and penalty ranges
- **Startup Cost Calculator** — realistic ranges by restaurant size
- **10 KPIs** — RevPASH, prime cost, table turns, waste %, and more
- **Delivery Platform Economics** — commission rates and when to go direct
- **Seasonal Revenue Patterns** — monthly index with planning notes

## Who It's For

- Restaurant owners planning expansion or new concepts
- Operators benchmarking against industry standards
- Consultants advising food service clients
- Anyone writing a restaurant business plan

## Usage

Install in your AI agent and ask questions like:
- "What should my food cost be for a fast casual concept?"
- "How many servers do I need for 80 seats at dinner?"
- "What's a realistic startup budget for a 3,000 sqft casual restaurant?"
- "Analyze my menu items using the engineering matrix"

## Want Full Automation?

This skill gives you the data. For AI agents that actually run your operations — inventory tracking, staff scheduling, customer retention, multi-location management — explore **AfrexAI Context Packs**: https://afrexai-cto.github.io/context-packs/

**AI Revenue Leak Calculator**: https://afrexai-cto.github.io/ai-revenue-calculator/

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
