# Contract & Subscription Renewal Management

Stop losing revenue to missed renewals and botched negotiations. This skill gives your agent a complete renewal management system — from 120-day cadence planning to save offers and dunning flows.

## What's Inside

- **120-day renewal cadence** with owner assignments and deliverables at each stage
- **Account health scoring** — 5-dimension weighted model to predict renewal outcomes
- **Pricing strategy by segment** — safe increase ranges for Enterprise through Self-Serve
- **Vendor negotiation playbook** — 7 discount levers with typical ranges (15-30%)
- **Revenue forecasting model** — committed/probable/at-risk/churning categories
- **Involuntary churn prevention** — dunning flow that recovers 60-80% of failed payments
- **Save offer matrix** — matched to cancellation reason with historical success rates
- **Automation checklist** — everything you need to put renewals on autopilot

## Who This Is For

- SaaS companies with recurring revenue
- Agencies managing client retainers
- CS/Account Management teams building renewal processes
- Ops leaders reducing churn and improving NRR
- Anyone negotiating vendor contract renewals (buy-side)

## Key Metrics This Improves

| Metric | Typical Before | After Implementation |
|--------|---------------|---------------------|
| Gross Renewal Rate | 80-85% | 90-95% |
| Net Revenue Retention | 95-100% | 110-120% |
| Involuntary Churn | 5-8% | 1-2% |
| Days to Close Renewal | 45-60 | 20-30 |

## Get More

- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — find where you're losing money
- [Industry Context Packs](https://afrexai-cto.github.io/context-packs/) — $47/pack with vertical-specific playbooks
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — configure your AI agent stack

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
