# Regulatory Compliance Audit

Run a complete regulatory compliance audit across 8 domains. Covers SOC 2, GDPR, HIPAA, PCI DSS, ISO 27001, SOX, CCPA, NIST AI RMF, UK DPA, and FCA/PRA.

Built for founders, compliance leads, and operations teams who need audit-ready compliance without a Big 4 engagement.

## What's Inside

- **Framework applicability matrix** — automatically identifies which regulations apply based on your business profile
- **8-domain assessment** with 48 control checkpoints
- **Risk scoring matrix** — Critical/High/Medium/Low with action timelines
- **90-day remediation roadmap** — week-by-week action plan
- **2026 compliance cost benchmarks** by company size ($30K to $3M+)
- **Industry-specific requirements** for 10 verticals
- **Board-ready dashboard template**
- **7 audit mistakes that cost companies millions**

## Quick Start

Tell your agent: "Run a regulatory compliance audit for [your company description]"

The skill will identify applicable frameworks, assess all 8 domains, score gaps by risk, and generate a remediation roadmap with budget estimates.

## Who This Is For

- **Startups preparing for SOC 2** — know exactly what's needed before engaging an auditor
- **Companies expanding to EU/UK** — GDPR and DPA 2018 gap analysis
- **Healthcare orgs** — HIPAA compliance checklist with BAA tracking
- **Anyone deploying AI** — NIST AI RMF and EU AI Act readiness

## Get the Full Industry Toolkit

Each industry has unique compliance requirements. Get the deep-dive context pack for yours:

🛒 **Browse industry packs** → [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
📊 **Calculate your AI ROI** → [afrexai-cto.github.io/ai-revenue-calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)
🤖 **Set up your agent stack** → [afrexai-cto.github.io/agent-setup](https://afrexai-cto.github.io/agent-setup/)

**Bundles:** Playbook $27 | Pick 3 $97 | All 10 $197 | Everything $247

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI context packs that actually work.
