# AI Recruiting Engine 🎯

Full-cycle recruiting agent for OpenClaw — source, screen, score, and hire top talent with zero dependencies.

## What It Does

Turns your AI agent into a recruiting machine:

- **Role Intake** — structured blueprints with must-haves, anti-patterns, and timeline
- **Sourcing** — channel effectiveness matrix, boolean search strings, 3 personalized outreach templates
- **Resume Screening** — 100-point scorecard across technical fit, impact evidence, and culture alignment
- **Interview Management** — phone screen, technical, and behavioral scorecards with STAR prompts
- **Pipeline Tracking** — YAML-based candidate pipeline with weekly health metrics
- **Offer & Closing** — verbal offer script, negotiation framework, rejection templates
- **D&I Checklist** — stage-by-stage diversity verification
- **Metrics Dashboard** — monthly reporting with channel ROI analysis

No APIs, no integrations, no setup. Pure agent knowledge.

## Install

```bash
clawhub install afrexai-recruiting-engine
```

## Quick Start

Tell your agent:
> "We need to hire a Senior Backend Engineer. Build me a role blueprint and sourcing plan."

Or:
> "Screen this resume against our open Product Manager role."

Or:
> "Give me a weekly pipeline health report for all open positions."

## ⚡ Level Up — Recruitment Context Pack

Want industry-specific recruiting frameworks? The **AfrexAI Recruitment Context Pack** ($47) includes:

- Recruitment industry landscape and market dynamics
- ATS integration patterns and compliance frameworks
- Candidate experience optimization playbooks
- Employer branding strategies by company stage
- Comp benchmarking data sources and analysis methods

👉 [Get the Recruitment Pack](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [Lead Hunter](https://clawhub.com/skills/afrexai-lead-hunter) — Source and score B2B prospects
- [Customer Support](https://clawhub.com/skills/afrexai-customer-support) — Ticket triage, CSAT, and retention
- [Meeting Mastery](https://clawhub.com/skills/afrexai-meeting-mastery) — Prep, run, and follow up on any meeting
- [SEO Content Engine](https://clawhub.com/skills/afrexai-seo-content-engine) — Research, write, and optimize content
- [Code Reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — PR review with SPEAR framework

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
