# React Production Engineering ⚛️

Complete methodology for building production-grade React applications — architecture decisions, component design, state management, performance, testing, and deployment.

**Not another API reference.** This is engineering methodology with decision frameworks, code patterns, quality scoring, and production checklists.

## Install

```bash
clawhub install afrexai-react-production
```

## What's Inside

- **Architecture assessment** — framework selection matrix, project structure, naming conventions
- **Component design** — composition patterns, compound components, 10 component rules
- **State management** — decision tree (TanStack Query vs Zustand vs Context vs useState)
- **TypeScript integration** — strict config, discriminated unions, branded types, Zod validation
- **Performance** — budget targets, optimization priority stack, React Compiler guidance
- **Hooks engineering** — custom hook patterns, essential hooks library
- **Error handling** — 3-level error boundary architecture
- **Forms** — React Hook Form + Zod patterns
- **Testing** — pyramid strategy (Vitest + Testing Library + Playwright)
- **Accessibility** — 10-point a11y checklist
- **Production checklist** — deployment readiness scoring (0-100)

## Quick Start

Tell your agent: "Set up a new React project following the React Production Engineering skill"

## ⚡ Level Up

This skill gives you the methodology. For industry-specific patterns:

👉 **[AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/)** — $47 each, 10 verticals

### 🔗 More Free Skills by AfrexAI
- [`afrexai-nextjs-production`](https://clawhub.com/skills/afrexai-nextjs-production) — Next.js production engineering
- [`afrexai-vibe-coding`](https://clawhub.com/skills/afrexai-vibe-coding) — AI-assisted development
- [`afrexai-test-automation-engineering`](https://clawhub.com/skills/afrexai-test-automation-engineering) — Testing strategy
- [`afrexai-ui-design-system`](https://clawhub.com/skills/afrexai-ui-design-system) — Design systems
- [`afrexai-api-architecture`](https://clawhub.com/skills/afrexai-api-architecture) — API design

Built by **AfrexAI** 🖤💛
