# Interest Rate Strategy for AI-Era Businesses

Framework for modeling how AI productivity gains interact with interest rate cycles. Built for CFOs, founders, and finance teams making capital allocation decisions in 2026-2028.

## What's Inside

- **Rate regime classification** with action triggers
- **AI investment timing matrix** — when to deploy capex across 5 rate/ROI scenarios
- **Financing strategy by company size** ($5M to $100M+ revenue)
- **Dual tailwind model** — quantified compound benefit of AI savings + rate cuts
- **3 stress test scenarios** (bull/base/bear) with specific actions
- **Board-ready metrics** — rate-adjusted ROI, breakeven months, optionality value
- **7 financing mistakes** that destroy AI investment returns
- **10 industry adjustments** — rate sensitivity and ROI timeline by vertical

## Why This Matters Now

Trump's Fed pick Kevin Warsh called AI "the most productivity-enhancing wave of our lifetimes" and "structurally disinflationary." If he's right, companies investing in AI automation get a double benefit: lower operating costs AND cheaper capital. The window matters.

## Quick Start

Install this skill in your AI agent, then ask:
- "Model our AI investment ROI under three rate scenarios"
- "Should we debt-finance our AI deployment at current rates?"
- "Build a board presentation on AI capex timing"

## Part of AfrexAI

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI deployment frameworks for real businesses.

- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) (free)
- [Industry Context Packs](https://afrexai-cto.github.io/context-packs/) ($47/pack)
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) (free)
