# RAG Engineering — Complete Retrieval-Augmented Generation System

> Build production RAG systems that actually work. From chunking strategy to evaluation — the complete methodology.

## What This Skill Does

Turns your AI agent into a RAG engineering expert. Covers the entire pipeline:

- **Architecture design** — Pattern selection, decision trees, project brief templates
- **Data ingestion** — Extraction, cleaning, metadata enrichment for every document type
- **Chunking strategy** — The #1 cause of bad RAG, solved with decision frameworks
- **Embedding selection** — Model comparison, benchmarking, cost optimization
- **Vector store setup** — Database selection, indexing strategy, hybrid search
- **Retrieval optimization** — Multi-query, HyDE, reranking, context assembly
- **Generation & prompting** — Grounding, citations, hallucination prevention
- **Evaluation framework** — Golden test sets, LLM-as-judge prompts, automated CI
- **Production deployment** — Security, caching, scaling, monitoring
- **Advanced patterns** — Agentic RAG, Graph RAG, CRAG, Self-RAG, multimodal

## Install

```bash
clawhub install afrexai-rag-engineering
```

## Quick Start

Tell your agent:
- "Design a RAG system for customer support documentation"
- "My RAG results are bad — help me diagnose"
- "Which embedding model should I use for code search?"
- "Help me set up RAG evaluation"

## What Makes This Different

- **37KB of pure methodology** — no API wrappers, no dependencies
- **Decision frameworks** for every choice (chunking, embeddings, vector DB, reranking)
- **Production-tested patterns** with specific thresholds and benchmarks
- **Complete evaluation system** with LLM-as-judge prompts and golden test set design
- **Diagnostic decision tree** for when things go wrong
- **Cost modeling** at every scale tier
- **100-point quality scoring rubric**

## ⚡ Level Up

Want industry-specific AI agent context? Our $47 context packs include complete agent configurations for your vertical:

- **SaaS Context Pack** — RAG for product docs, support, knowledge bases
- **Healthcare Context Pack** — RAG for clinical guidelines, patient education
- **Legal Context Pack** — RAG for case law, contracts, regulatory docs
- **Fintech Context Pack** — RAG for financial research, compliance docs

👉 [Browse all context packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-llmops-engine](https://clawhub.com/skills/afrexai-llmops-engine) — Production LLM operations
- [afrexai-agent-engineering](https://clawhub.com/skills/afrexai-agent-engineering) — Build autonomous AI agents
- [afrexai-mcp-engineering](https://clawhub.com/skills/afrexai-mcp-engineering) — Model Context Protocol servers
- [afrexai-prompt-engineering](https://clawhub.com/skills/afrexai-prompt-engineering) — Advanced prompt design
- [afrexai-data-engineering](https://clawhub.com/skills/afrexai-data-engineering) — Data pipeline methodology

---

**AfrexAI** — AI agents that compound capital and code. 🖤💛
