# 🧪 AfrexAI QA & Testing Engine

The most comprehensive testing skill on ClawHub. From unit tests to chaos engineering — a complete quality system for AI agents.

## What This Does

Turns your AI agent into a senior QA engineer. Covers the **full testing lifecycle**:

- **Test strategy design** with risk-based prioritization
- **Unit testing mastery** — AAA patterns, mocking rules, coverage targets
- **Integration testing** — API checklists, contract testing, database testing
- **E2E testing** — Critical journey mapping, selector strategy, flaky test triage
- **Performance testing** — Load/stress/soak/spike test design with budgets
- **Security testing** — OWASP Top 10 checklist, injection payloads, auth testing
- **Accessibility testing** — WCAG 2.1 Level AA compliance
- **CI pipeline design** — 5-stage test pipeline architecture
- **Quality metrics** — 100-point scoring system, health dashboard, reporting

## Install

```bash
clawhub install afrexai-qa-testing-engine
```

## Quick Start

Ask your agent:
- *"Create a test strategy for our payment service"*
- *"Write unit tests for this pricing calculator"*
- *"Security test our login endpoint"*
- *"What's our test health score?"*

## What's Inside

| Section | What You Get |
|---|---|
| Strategy Design | Risk matrix, test pyramid, scope template |
| Unit Testing | AAA pattern, naming conventions, mock rules, coverage targets |
| Integration | API checklist (20+ checks per endpoint), contract testing, DB rules |
| E2E | Journey mapping, selector priority, flaky test triage table |
| Performance | 5 test types with configs, budgets by app type, DB perf |
| Security | OWASP Top 10 checklist, injection payloads, validation tests |
| Automation | Framework selection guide, CI pipeline stages, test data management |
| Metrics | Quality score (0-100), dashboard YAML, report template |
| Accessibility | WCAG 2.1 A+AA checklist, tool recommendations |
| Chaos Engineering | Network, infra, app, data failure scenarios |

## ⚡ Level Up

Want testing frameworks tailored to your industry? Check out our **Context Packs** ($47):

- **SaaS Context Pack** — SaaS-specific test patterns, compliance testing, multi-tenant QA
- **Fintech Context Pack** — Financial calculation testing, regulatory compliance, audit trails
- **Healthcare Context Pack** — HIPAA compliance testing, PHI data handling, HL7/FHIR validation

👉 [Browse all packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — SPEAR code review framework
- [afrexai-api-architect](https://clawhub.com/skills/afrexai-api-architect) — Complete API lifecycle
- [afrexai-devops-engine](https://clawhub.com/skills/afrexai-devops-engine) — CI/CD & platform engineering
- [afrexai-technical-docs](https://clawhub.com/skills/afrexai-technical-docs) — Documentation system
- [afrexai-prd-engine](https://clawhub.com/skills/afrexai-prd-engine) — Product requirements

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
