# AfrexAI QA & Test Engineering Command Center

Complete quality assurance system for AI-powered agents — test strategy, automation frameworks, coverage analysis, performance testing, security audits, bug triage, and release readiness. Works for any stack, any team size.

## Install

```bash
clawhub install afrexai-qa-engine
```

## What It Does

Turn your AI agent into a senior QA engineer. This skill provides:

- **Test Strategy** — Risk-based test allocation, test pyramid enforcement
- **Unit Testing** — AAA pattern, mock guidelines, coverage targets, naming conventions
- **Integration Testing** — API contract testing, database integration, external service patterns
- **E2E Testing** — User journey templates, flaky test management, strategic test selection
- **Performance Testing** — Load/stress/spike/soak test plans with metric dashboards
- **Security Testing** — OWASP Top 10 checklist, auth/input/data/infra audit
- **Bug Triage** — Severity classification, bug report templates, weekly triage process
- **Release Readiness** — 5-dimension scoring (≥80 to ship), full checklist
- **CI/CD Quality Gates** — Pipeline gate configuration, automation maturity model
- **Test Maintenance** — Weekly health reviews, anti-pattern detection, hygiene rules

## Quick Start

Tell your agent:
- "Create test strategy for the auth module"
- "Write unit tests for calculateDiscount()"
- "Security checklist for the payment flow"
- "Release readiness check for v2.1"

## ⚡ Level Up

This free skill covers QA methodology. For industry-specific testing contexts (compliance requirements, regulatory testing, domain-specific edge cases):

**[SaaS Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — SaaS-specific testing patterns, multi-tenant edge cases, subscription billing tests

**[Healthcare Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — HIPAA compliance testing, PHI data handling, audit trail verification

**[Fintech Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — PCI-DSS testing, transaction integrity, reconciliation testing

## 🔗 More Free Skills by AfrexAI

- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — SPEAR code review framework with 60+ patterns
- [afrexai-api-architect](https://clawhub.com/skills/afrexai-api-architect) — Complete API lifecycle from design to monitoring
- [afrexai-prd-engine](https://clawhub.com/skills/afrexai-prd-engine) — PRD system with AI coding agent output format
- [afrexai-data-analyst](https://clawhub.com/skills/afrexai-data-analyst) — DICE analysis framework with SQL library
- [afrexai-business-automation](https://clawhub.com/skills/afrexai-business-automation) — 5-phase automation lifecycle

**Browse all AfrexAI skills:** [clawhub.com](https://clawhub.com) | [Context Packs Store](https://afrexai-cto.github.io/context-packs/)
