# Proposal Engine — Win More Deals 🖤💛

Turn discovery calls into winning proposals. Full lifecycle from qualification to close.

Most "proposal" tools help you format a document. This skill helps you **win the deal**.

## What You Get

- **BANT-Plus Qualification** — Score opportunities before wasting time writing
- **Discovery Extraction** — Structured framework to capture what matters from calls
- **Three-Tier Pricing** — Psychology-backed pricing strategy (not just a template)
- **Complete Proposal Structure** — Mirror → Solve → Prove → Ask formula
- **100-Point Quality Checklist** — Score your proposal before sending
- **Follow-Up Cadence** — 30-day system so deals don't die in inbox
- **Objection Handling** — Word-for-word responses to the 5 most common pushbacks
- **4 Proposal Templates** — Consulting, Software, Creative, RFP Response

## Install

```bash
clawhub install afrexai-proposal-engine
```

## Quick Start

Tell your agent:
- `"Create a proposal for [client]"` — full guided flow
- `"Score this opportunity"` — qualification check
- `"Help me price [project]"` — three-tier pricing builder
- `"Review my proposal"` — quality scoring + improvements

## What Makes This Different

The original `ai-proposal-generator` on ClawHub focuses on HTML templates and color themes — making proposals *look* nice.

This skill focuses on making proposals **win**:
- Qualification scoring so you don't waste time on bad-fit prospects
- Value-based pricing frameworks (not just hourly rates)
- Discovery-to-close methodology with follow-up sequences
- Objection handling scripts for the conversations that happen *after* you send

## ⚡ Level Up — Context Packs

Want industry-specific proposal templates, pricing benchmarks, and competitive positioning?

- **[SaaS Context Pack](https://afrexai-cto.github.io/context-packs/)** — SaaS pricing models, churn benchmarks, expansion revenue strategies
- **[Professional Services Pack](https://afrexai-cto.github.io/context-packs/)** — Consulting fee structures, SOW templates, utilization targets
- **[Legal Context Pack](https://afrexai-cto.github.io/context-packs/)** — Legal tech pricing, compliance frameworks, matter budgeting

Each pack is $47 and gives your agent deep vertical expertise.

**Full storefront:** https://afrexai-cto.github.io/context-packs/

## 🔗 More Free Skills by AfrexAI

- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — Find and qualify prospects
- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — SEO content that ranks
- [afrexai-meeting-mastery](https://clawhub.com/skills/afrexai-meeting-mastery) — Prep, run, and follow up on meetings
- [afrexai-customer-support](https://clawhub.com/skills/afrexai-customer-support) — Support + retention engine
- [afrexai-business-automation](https://clawhub.com/skills/afrexai-business-automation) — Automate repetitive workflows

---

*Built by AfrexAI — turning AI agents into revenue machines.* 🖤💛
