# Prompt Engineering Mastery

The complete prompt engineering system — from first draft to production-grade prompt libraries. CRAFT framework, chain-of-thought patterns, agent prompt architecture, domain-specific prompt libraries, testing methodology, cost optimization, and anti-pattern guide.

## Install

```bash
clawhub install afrexai-prompt-engineering
```

## What's Inside

- **CRAFT Framework** — 5-dimension prompt quality check
- **4-Layer Architecture** — System context → Task → Input → Output shaping
- **Advanced Techniques** — Chain-of-thought, prompt chaining, multi-persona, structured extraction, guardrails
- **Optimization Loop** — EVAL methodology with test case design, scoring rubrics, A/B testing
- **Agent & System Prompts** — Production templates for orchestrators, critics, multi-agent setups
- **Domain Libraries** — Ready-to-use prompts for support, sales, content, research, analysis
- **Prompt Management** — Versioning, review checklists, cost optimization, library structure
- **Model-Specific Tips** — Claude, GPT-4, open-source optimization guides
- **Production Patterns** — RAG prompts, agentic tool-use prompts, LLM-as-judge evaluation
- **15 Anti-Patterns** — The worst mistakes and how to fix them

## Quick Start

Tell your agent: *"Design a prompt for classifying customer support tickets by urgency"*

The skill walks through CRAFT design, output format, few-shot examples, test cases, and scoring.

## ⚡ Level Up

Want industry-specific prompt libraries pre-built for your vertical?

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)** include domain-tuned prompt templates, agent configurations, and automation playbooks for:
- SaaS, Fintech, Healthcare, Legal, Construction
- Ecommerce, Real Estate, Recruitment, Manufacturing, Professional Services

## 🔗 More Free Skills by AfrexAI

- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — SPEAR framework code review
- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — SEO content system
- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — ICP-based lead generation
- [afrexai-customer-support](https://clawhub.com/skills/afrexai-customer-support) — Full CS operations
- [afrexai-data-analyst](https://clawhub.com/skills/afrexai-data-analyst) — DICE analysis framework

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**

---

*Built by AfrexAI — engineering that compounds. 🖤💛*
