# Prompt Engineering Mastery ⚡

The complete prompt engineering methodology — from first draft to production-grade prompt systems. Covers the CRAFT framework, 10+ advanced techniques, domain-specific patterns, testing protocols, and prompt management.

## Install

```bash
clawhub install afrexai-prompt-engineering
```

## What's Inside

- **CRAFT Framework** — 5-layer prompt architecture (Context, Role, Action, Format, Tests)
- **Core Techniques** — Chain-of-thought, few-shot design, constraint engineering, persona calibration
- **System Prompt Engineering** — Full agent/skill system prompt architecture with 100-point quality rubric
- **Advanced Techniques** — Prompt chaining, self-consistency, meta-prompting, RAG patterns, adversarial defense
- **Domain Patterns** — Ready-to-use templates for analysis, writing, code generation, extraction, evaluation
- **Testing Protocol** — 6-case test suite template, iteration methodology, failure pattern diagnosis
- **Production Management** — Versioning, monitoring, documentation, alert thresholds
- **Patterns Library** — Verifier, Decomposer, Devil's Advocate, Calibrator, Persona Switcher
- **Anti-Patterns** — 10 common mistakes with fixes

## Quick Start

Ask your agent:
- "Write a prompt for [any task]" — builds using CRAFT framework
- "Review this prompt" — scores against 100-point rubric
- "Test this prompt" — generates diverse test suite
- "Debug this prompt" — diagnoses failure patterns

## Why This Over Others

The existing prompt engineering skills on ClawHub are 1-2KB of bullet-point advice. This is 28KB of actionable methodology with templates, rubrics, decision matrices, and real examples. Zero dependencies.

---

## ⚡ Level Up

Get the full **AI Agent Context Pack** for your industry — 5 files of production-ready agent configurations, workflows, and domain knowledge:

👉 [Browse Context Packs ($47)](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — SPEAR code review framework
- [afrexai-sales-playbook](https://clawhub.com/skills/afrexai-sales-playbook) — Complete B2B sales system
- [afrexai-founder-os](https://clawhub.com/skills/afrexai-founder-os) — Startup operating system
- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — SEO content methodology
- [afrexai-data-analyst](https://clawhub.com/skills/afrexai-data-analyst) — DICE analysis framework

👉 [All AfrexAI skills on ClawHub](https://clawhub.com/publishers/afrexai-cto)
